/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.release.plugin.SharedFunctions;
import org.apache.commons.release.plugin.velocity.HeaderHtmlVelocityDelegate;
import org.apache.commons.release.plugin.velocity.ReadmeHtmlVelocityDelegate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="stage-distributions", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, aggregator=true)
public class CommonsDistributionStagingMojo
extends AbstractMojo {
    private static final String README_FILE_NAME = "README.html";
    private static final String HEADER_FILE_NAME = "HEADER.html";
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}/site", property="commons.siteOutputDirectory")
    private File siteDirectory;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", property="commons.outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin/scm", property="commons.distCheckoutDirectory")
    private File distCheckoutDirectory;
    @Parameter(defaultValue="${basedir}/RELEASE-NOTES.txt", property="commons.releaseNotesLocation")
    private File releaseNotesFile;
    @Parameter(property="commons.release.dryRun", defaultValue="false")
    private Boolean dryRun;
    @Parameter(defaultValue="", property="commons.distSvnStagingUrl")
    private String distSvnStagingUrl;
    @Parameter(defaultValue="false", property="commons.release.isDistModule")
    private Boolean isDistModule;
    @Parameter(property="commons.release.version")
    private String commonsReleaseVersion;
    @Parameter(property="commons.rc.version")
    private String commonsRcVersion;
    @Parameter(property="commons.distServer")
    private String distServer;
    @Parameter(property="user.name")
    private String username;
    @Parameter(property="user.password")
    private String password;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;
    private File distVersionRcVersionDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isDistModule.booleanValue()) {
            this.getLog().info((CharSequence)"This module is marked as a non distribution or assembly module, and the plugin will not run.");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.distSvnStagingUrl)) {
            this.getLog().warn((CharSequence)"commons.distSvnStagingUrl is not set, the commons-release-plugin will not run.");
            return;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().info((CharSequence)"Current project contains no distributions. Not executing.");
            return;
        }
        this.getLog().info((CharSequence)"Preparing to stage distributions");
        try {
            BasicScmManager scmManager = new BasicScmManager();
            scmManager.setScmProvider("svn", (ScmProvider)new SvnExeScmProvider());
            ScmRepository repository = scmManager.makeScmRepository(this.distSvnStagingUrl);
            ScmProvider provider = scmManager.getProviderByRepository(repository);
            SvnScmProviderRepository providerRepository = (SvnScmProviderRepository)repository.getProviderRepository();
            SharedFunctions.setAuthentication((ScmProviderRepository)providerRepository, this.distServer, this.settings, this.settingsDecrypter, this.username, this.password);
            this.distVersionRcVersionDirectory = new File(this.distCheckoutDirectory, this.commonsReleaseVersion + "-" + this.commonsRcVersion);
            if (!this.distCheckoutDirectory.exists()) {
                SharedFunctions.initDirectory(this.getLog(), this.distCheckoutDirectory);
            }
            ScmFileSet scmFileSet = new ScmFileSet(this.distCheckoutDirectory);
            this.getLog().info((CharSequence)("Checking out dist from: " + this.distSvnStagingUrl));
            CheckOutScmResult checkOutResult = provider.checkOut(repository, scmFileSet);
            if (!checkOutResult.isSuccess()) {
                throw new MojoExecutionException("Failed to checkout files from SCM: " + checkOutResult.getProviderMessage() + " [" + checkOutResult.getCommandOutput() + "]");
            }
            File copiedReleaseNotes = this.copyReleaseNotesToWorkingDirectory();
            this.copyDistributionsIntoScmDirectoryStructureAndAddToSvn(copiedReleaseNotes, provider, repository);
            ArrayList<File> filesToAdd = new ArrayList<File>();
            this.listNotHiddenFilesAndDirectories(this.distCheckoutDirectory, filesToAdd);
            if (!this.dryRun.booleanValue()) {
                ScmFileSet fileSet = new ScmFileSet(this.distCheckoutDirectory, filesToAdd);
                AddScmResult addResult = provider.add(repository, fileSet);
                if (!addResult.isSuccess()) {
                    throw new MojoExecutionException("Failed to add files to SCM: " + addResult.getProviderMessage() + " [" + addResult.getCommandOutput() + "]");
                }
                this.getLog().info((CharSequence)("Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion()));
                CheckInScmResult checkInResult = provider.checkIn(repository, fileSet, "Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion());
                if (!checkInResult.isSuccess()) {
                    this.getLog().error((CharSequence)("Committing dist files failed: " + checkInResult.getCommandOutput()));
                    throw new MojoExecutionException("Committing dist files failed: " + checkInResult.getCommandOutput());
                }
                this.getLog().info((CharSequence)("Committed revision " + checkInResult.getScmRevision()));
            } else {
                this.getLog().info((CharSequence)("[Dry run] Would have committed to: " + this.distSvnStagingUrl));
                this.getLog().info((CharSequence)("[Dry run] Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion()));
            }
        }
        catch (ScmException e) {
            this.getLog().error((CharSequence)("Could not commit files to dist: " + this.distSvnStagingUrl), (Throwable)e);
            throw new MojoExecutionException("Could not commit files to dist: " + this.distSvnStagingUrl, (Exception)((Object)e));
        }
    }

    private void listNotHiddenFilesAndDirectories(File directory, List<File> files) {
        File[] fList;
        for (File file : fList = directory.listFiles()) {
            if (file.isFile() && !file.isHidden()) {
                files.add(file);
                continue;
            }
            if (!file.isDirectory() || file.isHidden()) continue;
            files.add(file);
            this.listNotHiddenFilesAndDirectories(file, files);
        }
    }

    private File copyReleaseNotesToWorkingDirectory() throws MojoExecutionException {
        SharedFunctions.initDirectory(this.getLog(), this.distVersionRcVersionDirectory);
        this.getLog().info((CharSequence)"Copying RELEASE-NOTES.txt to working directory.");
        File copiedReleaseNotes = new File(this.distVersionRcVersionDirectory, this.releaseNotesFile.getName());
        SharedFunctions.copyFile(this.getLog(), this.releaseNotesFile, copiedReleaseNotes);
        return copiedReleaseNotes;
    }

    private List<File> copyDistributionsIntoScmDirectoryStructureAndAddToSvn(File copiedReleaseNotes, ScmProvider provider, ScmRepository repository) throws MojoExecutionException {
        List<File> workingDirectoryFiles = Arrays.asList(this.workingDirectory.listFiles());
        ArrayList<File> filesForMavenScmFileSet = new ArrayList<File>();
        File scmBinariesRoot = new File(this.distVersionRcVersionDirectory, "binaries");
        File scmSourceRoot = new File(this.distVersionRcVersionDirectory, "source");
        SharedFunctions.initDirectory(this.getLog(), scmBinariesRoot);
        SharedFunctions.initDirectory(this.getLog(), scmSourceRoot);
        for (File file : workingDirectoryFiles) {
            File copy;
            if (file.getName().contains("src")) {
                copy = new File(scmSourceRoot, file.getName());
                SharedFunctions.copyFile(this.getLog(), file, copy);
                filesForMavenScmFileSet.add(file);
                continue;
            }
            if (file.getName().contains("bin")) {
                copy = new File(scmBinariesRoot, file.getName());
                SharedFunctions.copyFile(this.getLog(), file, copy);
                filesForMavenScmFileSet.add(file);
                continue;
            }
            if (StringUtils.containsAny((CharSequence)file.getName(), (CharSequence[])new CharSequence[]{"scm", "sha256.properties", "sha512.properties"})) {
                this.getLog().debug((CharSequence)"Not copying scm directory over to the scm directory because it is the scm directory.");
                continue;
            }
            copy = new File(this.distCheckoutDirectory.getAbsolutePath(), file.getName());
            SharedFunctions.copyFile(this.getLog(), file, copy);
            filesForMavenScmFileSet.add(file);
        }
        filesForMavenScmFileSet.addAll(this.buildReadmeAndHeaderHtmlFiles());
        filesForMavenScmFileSet.addAll(this.copySiteToScmDirectory());
        return filesForMavenScmFileSet;
    }

    private List<File> copySiteToScmDirectory() throws MojoExecutionException {
        if (!this.siteDirectory.exists()) {
            this.getLog().error((CharSequence)"\"mvn site\" was not run before this goal, or a siteDirectory did not exist.");
            throw new MojoExecutionException("\"mvn site\" was not run before this goal, or a siteDirectory did not exist.");
        }
        File siteInScm = new File(this.distVersionRcVersionDirectory, "site");
        try {
            FileUtils.copyDirectory((File)this.siteDirectory, (File)siteInScm);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Site copying failed", (Exception)e);
        }
        return new ArrayList<File>(FileUtils.listFiles((File)siteInScm, null, (boolean)true));
    }

    private List<File> buildReadmeAndHeaderHtmlFiles() throws MojoExecutionException {
        ArrayList<File> headerAndReadmeFiles = new ArrayList<File>();
        File headerFile = new File(this.distVersionRcVersionDirectory, HEADER_FILE_NAME);
        try (OutputStreamWriter headerWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(headerFile), "UTF-8");){
            HeaderHtmlVelocityDelegate.builder().build().render(headerWriter);
        }
        catch (IOException e) {
            String message = "Could not build HEADER html file " + headerFile;
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
        headerAndReadmeFiles.add(headerFile);
        File readmeFile = new File(this.distVersionRcVersionDirectory, README_FILE_NAME);
        try (OutputStreamWriter readmeWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(readmeFile), "UTF-8");){
            ReadmeHtmlVelocityDelegate readmeHtmlVelocityDelegate = ReadmeHtmlVelocityDelegate.builder().withArtifactId(this.project.getArtifactId()).withVersion(this.project.getVersion()).withSiteUrl(this.project.getUrl()).build();
            readmeHtmlVelocityDelegate.render(readmeWriter);
        }
        catch (IOException e) {
            String message = "Could not build README html file " + readmeFile;
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
        headerAndReadmeFiles.add(readmeFile);
        headerAndReadmeFiles.addAll(this.copyHeaderAndReadmeToSubdirectories(headerFile, readmeFile));
        return headerAndReadmeFiles;
    }

    private List<File> copyHeaderAndReadmeToSubdirectories(File headerFile, File readmeFile) throws MojoExecutionException {
        ArrayList<File> symbolicLinkFiles = new ArrayList<File>();
        File sourceRoot = new File(this.distVersionRcVersionDirectory, "source");
        File binariesRoot = new File(this.distVersionRcVersionDirectory, "binaries");
        File sourceHeaderFile = new File(sourceRoot, HEADER_FILE_NAME);
        File sourceReadmeFile = new File(sourceRoot, README_FILE_NAME);
        File binariesHeaderFile = new File(binariesRoot, HEADER_FILE_NAME);
        File binariesReadmeFile = new File(binariesRoot, README_FILE_NAME);
        SharedFunctions.copyFile(this.getLog(), headerFile, sourceHeaderFile);
        symbolicLinkFiles.add(sourceHeaderFile);
        SharedFunctions.copyFile(this.getLog(), readmeFile, sourceReadmeFile);
        symbolicLinkFiles.add(sourceReadmeFile);
        SharedFunctions.copyFile(this.getLog(), headerFile, binariesHeaderFile);
        symbolicLinkFiles.add(binariesHeaderFile);
        SharedFunctions.copyFile(this.getLog(), readmeFile, binariesReadmeFile);
        symbolicLinkFiles.add(binariesReadmeFile);
        return symbolicLinkFiles;
    }

    protected void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

