/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.release.plugin.SharedFunctions;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="detach-distributions", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, aggregator=true)
public class CommonsDistributionDetachmentMojo
extends AbstractMojo {
    private static final Set<String> ARTIFACT_TYPES_TO_DETACH;
    private final List<Artifact> detachedArtifacts = new ArrayList<Artifact>();
    private final Properties artifactSha512s = new Properties();
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", property="commons.outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="", property="commons.distSvnStagingUrl")
    private String distSvnStagingUrl;
    @Parameter(defaultValue="false", property="commons.release.isDistModule")
    private Boolean isDistModule;

    public void execute() throws MojoExecutionException {
        if (!this.isDistModule.booleanValue()) {
            this.getLog().info((CharSequence)"This module is marked as a non distribution or assembly module, and the plugin will not run.");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.distSvnStagingUrl)) {
            this.getLog().warn((CharSequence)"commons.distSvnStagingUrl is not set, the commons-release-plugin will not run.");
            return;
        }
        this.getLog().info((CharSequence)"Detaching Assemblies");
        for (Object attachedArtifact : this.project.getAttachedArtifacts()) {
            this.putAttachedArtifactInSha512Map((Artifact)attachedArtifact);
            if (!ARTIFACT_TYPES_TO_DETACH.contains(((Artifact)attachedArtifact).getType())) continue;
            this.detachedArtifacts.add((Artifact)attachedArtifact);
        }
        if (this.detachedArtifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Current project contains no distributions. Not executing.");
            return;
        }
        for (Artifact artifactToRemove : this.detachedArtifacts) {
            this.project.getAttachedArtifacts().remove(artifactToRemove);
        }
        if (!this.workingDirectory.exists()) {
            SharedFunctions.initDirectory(this.getLog(), this.workingDirectory);
        }
        this.writeAllArtifactsInSha512PropertiesFile();
        this.copyRemovedArtifactsToWorkingDirectory();
        this.getLog().info((CharSequence)"");
        this.hashArtifacts();
    }

    private void putAttachedArtifactInSha512Map(Artifact artifact) throws MojoExecutionException {
        try {
            String artifactKey = this.getArtifactKey(artifact);
            try (FileInputStream fis = new FileInputStream(artifact.getFile());){
                this.artifactSha512s.put(artifactKey, DigestUtils.sha512Hex((InputStream)fis));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not find artifact signature for: " + artifact.getArtifactId() + "-" + artifact.getClassifier() + "-" + artifact.getVersion() + " type: " + artifact.getType(), (Exception)e);
        }
    }

    private void writeAllArtifactsInSha512PropertiesFile() throws MojoExecutionException {
        File propertiesFile = new File(this.workingDirectory, "sha512.properties");
        this.getLog().info((CharSequence)("Writting " + propertiesFile));
        try (FileOutputStream fileWriter = new FileOutputStream(propertiesFile);){
            this.artifactSha512s.store(fileWriter, "Release SHA-512s");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure to write SHA-512's", (Exception)e);
        }
    }

    private void copyRemovedArtifactsToWorkingDirectory() throws MojoExecutionException {
        String wdAbsolutePath = this.workingDirectory.getAbsolutePath();
        this.getLog().info((CharSequence)("Copying " + this.detachedArtifacts.size() + " detached artifacts to working directory " + wdAbsolutePath));
        for (Artifact artifact : this.detachedArtifacts) {
            File artifactFile = artifact.getFile();
            StringBuilder copiedArtifactAbsolutePath = new StringBuilder(wdAbsolutePath);
            copiedArtifactAbsolutePath.append("/");
            copiedArtifactAbsolutePath.append(artifactFile.getName());
            File copiedArtifact = new File(copiedArtifactAbsolutePath.toString());
            this.getLog().info((CharSequence)("Copying: " + artifactFile.getName()));
            SharedFunctions.copyFile(this.getLog(), artifactFile, copiedArtifact);
        }
    }

    private void hashArtifacts() throws MojoExecutionException {
        for (Artifact artifact : this.detachedArtifacts) {
            if (artifact.getFile().getName().contains("asc")) continue;
            String artifactKey = this.getArtifactKey(artifact);
            try {
                String digest = this.artifactSha512s.getProperty(artifactKey.toString());
                this.getLog().info((CharSequence)(artifact.getFile().getName() + " sha512: " + digest));
                PrintWriter printWriter = new PrintWriter(this.getSha512FilePath(this.workingDirectory, artifact.getFile()));
                Throwable throwable = null;
                try {
                    printWriter.println(digest);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (printWriter == null) continue;
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    printWriter.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not sign file: " + artifact.getFile().getName(), (Exception)e);
            }
        }
    }

    private String getSha512FilePath(File directory, File file) {
        StringBuilder buffer = new StringBuilder(directory.getAbsolutePath());
        buffer.append("/");
        buffer.append(file.getName());
        buffer.append(".sha512");
        return buffer.toString();
    }

    private String getArtifactKey(Artifact artifact) {
        StringBuilder artifactKey = new StringBuilder();
        artifactKey.append(artifact.getArtifactId()).append('-').append(artifact.getVersion()).append('-');
        if (artifact.hasClassifier()) {
            artifactKey.append(artifact.getClassifier()).append('-');
        }
        artifactKey.append(artifact.getType());
        return artifactKey.toString();
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("zip");
        hashSet.add("tar.gz");
        hashSet.add("zip.asc");
        hashSet.add("tar.gz.asc");
        ARTIFACT_TYPES_TO_DETACH = Collections.unmodifiableSet(hashSet);
    }
}

