/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.FileUtils;

public final class SharedFunctions {
    public static final int BUFFER_BYTE_SIZE = 1024;

    private SharedFunctions() {
    }

    public static void initDirectory(Log log, File workingDirectory) throws MojoExecutionException {
        if (workingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)workingDirectory);
            }
            catch (IOException | NullPointerException e) {
                String message = String.format("Unable to remove directory %s: %s", workingDirectory, e.getMessage());
                log.error((CharSequence)message);
                throw new MojoExecutionException(message, e);
            }
        }
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
    }

    public static void copyFile(Log log, File fromFile, File toFile) throws MojoExecutionException {
        try {
            FileUtils.copyFile((File)fromFile, (File)toFile);
        }
        catch (IOException | NullPointerException e) {
            String message = String.format("Unable to copy file %s tp %s: %s", fromFile, toFile, e.getMessage());
            log.error((CharSequence)message);
            throw new MojoExecutionException(message, e);
        }
    }

    public static void setAuthentication(ScmProviderRepository providerRepository, String distServer, Settings settings, SettingsDecrypter settingsDecrypter, String username, String password) {
        Optional<Server> server = Optional.ofNullable(distServer).map(arg_0 -> ((Settings)settings).getServer(arg_0)).map(DefaultSettingsDecryptionRequest::new).map(arg_0 -> ((SettingsDecrypter)settingsDecrypter).decrypt(arg_0)).map(SettingsDecryptionResult::getServer);
        providerRepository.setUser(server.map(Server::getUsername).orElse(username));
        providerRepository.setPassword(server.map(Server::getPassword).orElse(password));
    }
}

