/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.velocity;

import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class ReadmeHtmlVelocityDelegate {
    private static final String TEMPLATE = "resources/org/apache/commons/release/plugin/velocity/README.vm";
    private final String artifactId;
    private final String version;
    private final String siteUrl;

    private ReadmeHtmlVelocityDelegate(String artifactId, String version, String siteUrl) {
        this.artifactId = artifactId;
        this.version = version;
        this.siteUrl = siteUrl;
    }

    public static ReadmeHtmlVelocityDelegateBuilder builder() {
        return new ReadmeHtmlVelocityDelegateBuilder();
    }

    public Writer render(Writer writer) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        Template template = ve.getTemplate(TEMPLATE);
        String[] splitArtifactId = this.artifactId.split("-");
        String wordCommons = splitArtifactId[0];
        String artifactShortName = splitArtifactId[1];
        String artifactIdWithFirstLetterscapitalized = StringUtils.capitalize((String)wordCommons) + "-" + artifactShortName.toUpperCase();
        VelocityContext context = new VelocityContext();
        context.internalPut("artifactIdWithFirstLetterscapitalized", (Object)artifactIdWithFirstLetterscapitalized);
        context.internalPut("artifactShortName", (Object)artifactShortName.toUpperCase());
        context.internalPut("artifactId", (Object)this.artifactId);
        context.internalPut("version", (Object)this.version);
        context.internalPut("siteUrl", (Object)this.siteUrl);
        template.merge((Context)context, writer);
        return writer;
    }

    public static class ReadmeHtmlVelocityDelegateBuilder {
        private String artifactId;
        private String version;
        private String siteUrl;

        private ReadmeHtmlVelocityDelegateBuilder() {
        }

        public ReadmeHtmlVelocityDelegateBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public ReadmeHtmlVelocityDelegateBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public ReadmeHtmlVelocityDelegateBuilder withSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
            return this;
        }

        public ReadmeHtmlVelocityDelegate build() {
            return new ReadmeHtmlVelocityDelegate(this.artifactId, this.version, this.siteUrl);
        }
    }
}

