/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public final class SharedFunctions {
    public static final int BUFFER_BYTE_SIZE = 1024;

    private SharedFunctions() {
    }

    public static void initDirectory(Log log, File workingDirectory) throws MojoExecutionException {
        if (workingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)workingDirectory);
            }
            catch (IOException | NullPointerException e) {
                String message = String.format("Unable to remove directory %s: %s", workingDirectory, e.getMessage());
                log.error((CharSequence)message);
                throw new MojoExecutionException(message, e);
            }
        }
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
    }

    public static void copyFile(Log log, File fromFile, File toFile) throws MojoExecutionException {
        try {
            FileUtils.copyFile((File)fromFile, (File)toFile);
        }
        catch (IOException | NullPointerException e) {
            String message = String.format("Unable to copy file %s tp %s: %s", fromFile, toFile, e.getMessage());
            log.error((CharSequence)message);
            throw new MojoExecutionException(message, e);
        }
    }
}

