/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsDistributionDetachmentMojo;
import org.apache.commons.release.plugin.mojos.CommonsDistributionStagingMojo;
import org.apache.maven.plugin.testing.MojoRule;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CommonsDistributionStagingMojoTest {
    private static final String COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH = "target/testing-commons-release-plugin";
    @Rule
    public MojoRule rule = new MojoRule(){

        protected void before() throws Throwable {
        }

        protected void after() {
        }
    };
    private CommonsDistributionDetachmentMojo detachmentMojo;
    private CommonsDistributionStagingMojo mojoForTest;

    @Before
    public void setUp() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        if (testingDirectory.exists()) {
            FileUtils.deleteDirectory((File)testingDirectory);
        }
    }

    @Test
    public void testSuccess() throws Exception {
        File testPom = new File("src/test/resources/mojos/stage-distributions/stage-distributions.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        File detachmentPom = new File("src/test/resources/mojos/detach-distributions/detach-distributions.xml");
        Assert.assertNotNull((Object)detachmentPom);
        TestCase.assertTrue((boolean)detachmentPom.exists());
        this.mojoForTest = (CommonsDistributionStagingMojo)this.rule.lookupMojo("stage-distributions", testPom);
        this.detachmentMojo = (CommonsDistributionDetachmentMojo)this.rule.lookupMojo("detach-distributions", detachmentPom);
        this.detachmentMojo.execute();
        File releaseNotesBasedir = new File("src/test/resources/mojos/stage-distributions/");
        this.mojoForTest.setBaseDir(releaseNotesBasedir);
        this.mojoForTest.execute();
        this.assertRequisiteFilesExist();
    }

    @Test
    public void testDisabled() throws Exception {
        File testPom = new File("src/test/resources/mojos/stage-distributions/stage-distributions-disabled.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojoForTest = (CommonsDistributionStagingMojo)this.rule.lookupMojo("stage-distributions", testPom);
        this.mojoForTest.execute();
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        Assert.assertFalse((boolean)testingDirectory.exists());
    }

    private void assertRequisiteFilesExist() {
        File targetScmDirectory = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1");
        File releaseNotes = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/RELEASE-NOTES.txt");
        File readmeHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/README.html");
        File headerHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/HEADER.html");
        File binariesReadmeHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/README.html");
        File binariesHeaderHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/HEADER.html");
        File binTar = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.tar.gz");
        File binTarASC = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.tar.gz.asc");
        File binTarSHA1 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.tar.gz.sha1");
        File binTarSHA256 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.tar.gz.sha256");
        File binZip = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.zip");
        File binZipASC = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.zip.asc");
        File binZipSHA1 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.zip.sha1");
        File binZipSHA256 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/commons-text-1.4-bin.zip.sha256");
        File sourcesReadmeHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/README.html");
        File sourceHeaderHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/binaries/HEADER.html");
        File srcTar = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.tar.gz");
        File srcTarASC = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.tar.gz.asc");
        File srcTarSHA1 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.tar.gz.sha1");
        File srcTarSHA256 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.tar.gz.sha256");
        File srcZip = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.zip");
        File srcZipASC = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.zip.asc");
        File srcZipSHA1 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.zip.sha1");
        File srcZipSHA256 = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/source/commons-text-1.4-src.zip.sha256");
        File site = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/site");
        File siteIndexHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/site/index.html");
        File siteSubdirectory = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/site/subdirectory");
        File siteSubdirectoryIndexHtml = new File("target/testing-commons-release-plugin/scm/1.0-SNAPSHOT-RC1/site/subdirectory/index.html");
        TestCase.assertTrue((boolean)targetScmDirectory.exists());
        TestCase.assertTrue((boolean)releaseNotes.exists());
        TestCase.assertTrue((boolean)readmeHtml.exists());
        TestCase.assertTrue((boolean)headerHtml.exists());
        TestCase.assertTrue((boolean)binariesReadmeHtml.exists());
        TestCase.assertTrue((boolean)binariesHeaderHtml.exists());
        TestCase.assertTrue((boolean)binTar.exists());
        TestCase.assertTrue((boolean)binTarASC.exists());
        TestCase.assertTrue((boolean)binTarSHA1.exists());
        TestCase.assertTrue((boolean)binTarSHA256.exists());
        TestCase.assertTrue((boolean)binZip.exists());
        TestCase.assertTrue((boolean)binZipASC.exists());
        TestCase.assertTrue((boolean)binZipSHA1.exists());
        TestCase.assertTrue((boolean)binZipSHA256.exists());
        TestCase.assertTrue((boolean)sourcesReadmeHtml.exists());
        TestCase.assertTrue((boolean)sourceHeaderHtml.exists());
        TestCase.assertTrue((boolean)srcTar.exists());
        TestCase.assertTrue((boolean)srcTarASC.exists());
        TestCase.assertTrue((boolean)srcTarSHA1.exists());
        TestCase.assertTrue((boolean)srcTarSHA256.exists());
        TestCase.assertTrue((boolean)srcZip.exists());
        TestCase.assertTrue((boolean)srcZipASC.exists());
        TestCase.assertTrue((boolean)srcZipSHA1.exists());
        TestCase.assertTrue((boolean)srcZipSHA256.exists());
        TestCase.assertTrue((boolean)site.exists());
        TestCase.assertTrue((boolean)siteIndexHtml.exists());
        TestCase.assertTrue((boolean)siteSubdirectory.exists());
        TestCase.assertTrue((boolean)siteSubdirectoryIndexHtml.exists());
    }
}

