/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsDistributionDetachmentMojo;
import org.apache.maven.plugin.testing.MojoRule;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CommonsDistributionDetachmentMojoTest {
    private static final String COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH = "target/testing-commons-release-plugin";
    @Rule
    public MojoRule rule = new MojoRule(){

        protected void before() throws Throwable {
        }

        protected void after() {
        }
    };
    private CommonsDistributionDetachmentMojo mojo;

    @Before
    public void setUp() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        if (testingDirectory.exists()) {
            FileUtils.deleteDirectory((File)testingDirectory);
        }
    }

    @Test
    public void testSuccess() throws Exception {
        File testPom = new File("src/test/resources/mojos/detach-distributions/detach-distributions.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsDistributionDetachmentMojo)this.rule.lookupMojo("detach-distributions", testPom);
        this.mojo.execute();
        File detachedSrcTarGz = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz");
        File detachedSrcTarGzAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz.asc");
        File detachedSrcTarGzSha1 = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz.sha1");
        File detachedSrcTarGzSha256 = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz.sha256");
        File detachedSrcZip = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip");
        File detachedSrcZipAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip.asc");
        File detachedSrcZipSha1 = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip.sha1");
        File detachedSrcZipSha256 = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip.sha256");
        File detachedBinTarGz = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz");
        File detachedBinTarGzAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz.asc");
        File detachedBinTarGzSha1 = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz.sha1");
        File detachedBinTarGzSha256 = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz.sha256");
        File detachedBinZip = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip");
        File detachedBinZipAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip.asc");
        File detachedBinZipSha1 = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip.sha1");
        File detachedBinZipSha256 = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip.sha256");
        File notDetachedMockAttachedFile = new File("target/testing-commons-release-plugin/commons-text-1.4.jar");
        File sha1Properties = new File("target/testing-commons-release-plugin/sha1.properties");
        File sha256Properties = new File("target/testing-commons-release-plugin/sha256.properties");
        TestCase.assertTrue((boolean)detachedSrcTarGz.exists());
        TestCase.assertTrue((boolean)detachedSrcTarGzAsc.exists());
        TestCase.assertTrue((boolean)detachedSrcTarGzSha1.exists());
        TestCase.assertTrue((boolean)detachedSrcTarGzSha256.exists());
        TestCase.assertTrue((boolean)detachedSrcZip.exists());
        TestCase.assertTrue((boolean)detachedSrcZipAsc.exists());
        TestCase.assertTrue((boolean)detachedSrcZipSha1.exists());
        TestCase.assertTrue((boolean)detachedSrcZipSha256.exists());
        TestCase.assertTrue((boolean)detachedBinTarGz.exists());
        TestCase.assertTrue((boolean)detachedBinTarGzAsc.exists());
        TestCase.assertTrue((boolean)detachedBinTarGzSha1.exists());
        TestCase.assertTrue((boolean)detachedBinTarGzSha256.exists());
        TestCase.assertTrue((boolean)detachedBinZip.exists());
        TestCase.assertTrue((boolean)detachedBinZipAsc.exists());
        TestCase.assertTrue((boolean)detachedBinZipSha1.exists());
        TestCase.assertTrue((boolean)detachedBinZipSha256.exists());
        TestCase.assertTrue((boolean)sha1Properties.exists());
        TestCase.assertTrue((boolean)sha256Properties.exists());
        Assert.assertFalse((boolean)notDetachedMockAttachedFile.exists());
    }

    @Test
    public void testDisabled() throws Exception {
        File testPom = new File("src/test/resources/mojos/detach-distributions/detach-distributions-disabled.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsDistributionDetachmentMojo)this.rule.lookupMojo("detach-distributions", testPom);
        this.mojo.execute();
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        Assert.assertFalse((boolean)testingDirectory.exists());
    }
}

