/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsDistributionDetachmentMojo;
import org.apache.maven.plugin.testing.MojoRule;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CommonsDistributionDetachmentMojoTest {
    private static final String COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH = "target/testing-commons-release-plugin";
    @Rule
    public MojoRule rule = new MojoRule(){

        protected void before() throws Throwable {
        }

        protected void after() {
        }
    };
    private CommonsDistributionDetachmentMojo mojo;

    @Before
    public void setUp() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        if (testingDirectory.exists()) {
            FileUtils.deleteDirectory((File)testingDirectory);
        }
    }

    @Test
    public void testSuccess() throws Exception {
        File testPom = new File("src/test/resources/mojos/detach-distributions/detach-distributions.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsDistributionDetachmentMojo)this.rule.lookupMojo("detach-distributions", testPom);
        this.mojo.execute();
        File detachedTarGz = new File("target/testing-commons-release-plugin/mockAttachedTar.tar.gz");
        File detachedTarGzAsc = new File("target/testing-commons-release-plugin/mockAttachedTar.tar.gz.asc");
        File detachedTarMd5 = new File("target/testing-commons-release-plugin/mockAttachedTar.tar.gz.md5");
        File detachedTarGzSha1 = new File("target/testing-commons-release-plugin/mockAttachedTar.tar.gz.sha1");
        File detachedZip = new File("target/testing-commons-release-plugin/mockAttachedZip.zip");
        File detachedZipAsc = new File("target/testing-commons-release-plugin/mockAttachedZip.zip.asc");
        File detachedZipMd5 = new File("target/testing-commons-release-plugin/mockAttachedZip.zip.md5");
        File detachedZipSha1 = new File("target/testing-commons-release-plugin/mockAttachedZip.zip.sha1");
        File notDetachedMockAttachedFile = new File("target/testing-commons-release-plugin/mockAttachedFile.html");
        TestCase.assertTrue((boolean)detachedTarGz.exists());
        TestCase.assertTrue((boolean)detachedTarGzAsc.exists());
        TestCase.assertTrue((boolean)detachedTarMd5.exists());
        TestCase.assertTrue((boolean)detachedTarGzSha1.exists());
        TestCase.assertTrue((boolean)detachedZip.exists());
        TestCase.assertTrue((boolean)detachedZipAsc.exists());
        TestCase.assertTrue((boolean)detachedZipMd5.exists());
        TestCase.assertTrue((boolean)detachedZipSha1.exists());
        Assert.assertFalse((boolean)notDetachedMockAttachedFile.exists());
    }

    @Test
    public void testDisabled() throws Exception {
        File testPom = new File("src/test/resources/mojos/detach-distributions/detach-distributions-disabled.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsDistributionDetachmentMojo)this.rule.lookupMojo("detach-distributions", testPom);
        this.mojo.execute();
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        Assert.assertFalse((boolean)testingDirectory.exists());
    }
}

