/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.binary.Base64Test;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.Codec105ErrorInputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Base64InputStreamTest {
    private static final String ENCODED_B64 = "AAAA////";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};
    private static final String STRING_FIXTURE = "Hello World";

    Base64InputStreamTest() {
    }

    @Test
    void testAvailable() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assertions.assertEquals((int)1, (int)b64stream.available());
            Assertions.assertEquals((long)6L, (long)b64stream.skip(10L));
            Assertions.assertEquals((int)0, (int)b64stream.available());
            Assertions.assertEquals((int)-1, (int)b64stream.read());
            Assertions.assertEquals((int)-1, (int)b64stream.read());
            Assertions.assertEquals((int)0, (int)b64stream.available());
        }
    }

    private void testBase64EmptyInputStream(int chuckSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chuckSize, CRLF);
        this.testByChunk(emptyEncoded, emptyDecoded, chuckSize, CRLF);
    }

    @Test
    void testBase64EmptyInputStreamMimeChuckSize() throws Exception {
        this.testBase64EmptyInputStream(76);
    }

    @Test
    void testBase64EmptyInputStreamPemChuckSize() throws Exception {
        this.testBase64EmptyInputStream(64);
    }

    @Test
    void testBase64InputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"SGVsbG8gV29ybGQ=\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA==\r\n");
        decoded = new byte[]{0};
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n");
        decoded = BaseNTestData.DECODED;
        this.testByChunk(encoded, decoded, 64, LF);
        String singleLine = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n".replace("\n", "");
        encoded = StringUtils.getBytesUtf8((String)singleLine);
        decoded = BaseNTestData.DECODED;
        this.testByChunk(encoded, decoded, 0, LF);
        Base64 codec = new Base64(0, null, false);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    void testBase64InputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"SGVsbG8gV29ybGQ=\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA==\r\n");
        decoded = new byte[]{0};
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n");
        decoded = BaseNTestData.DECODED;
        this.testByteByByte(encoded, decoded, 64, LF);
        String singleLine = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n".replace("\n", "");
        encoded = StringUtils.getBytesUtf8((String)singleLine);
        decoded = BaseNTestData.DECODED;
        this.testByteByByte(encoded, decoded, 0, LF);
        Base64 codec = new Base64(0, null, false);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        byte[] output;
        try (Object in = new Base64InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);){
            output = BaseNTestData.streamToBytes((InputStream)in);
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming base64 encode");
        }
        in = new Base64InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = BaseNTestData.streamToBytes((InputStream)in);
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base64 decode");
        in = new ByteArrayInputStream(decoded);
        for (int i = 0; i < 10; ++i) {
            in = new Base64InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base64InputStream((InputStream)in, false);
        }
        output = BaseNTestData.streamToBytes((InputStream)in);
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base64 wrap-wrap-wrap!");
        ((InputStream)in).close();
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        int i;
        byte[] output = new byte[encoded.length];
        try (Object in = new Base64InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);){
            for (i = 0; i < output.length; ++i) {
                output[i] = (byte)((InputStream)in).read();
            }
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming base64 encode");
        }
        in = new Base64InputStream((InputStream)new ByteArrayInputStream(encoded));
        try {
            output = new byte[decoded.length];
            for (i = 0; i < output.length; ++i) {
                output[i] = (byte)((InputStream)in).read();
            }
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base64 decode");
        }
        finally {
            ((InputStream)in).close();
        }
        in = new ByteArrayInputStream(decoded);
        for (i = 0; i < 10; ++i) {
            in = new Base64InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base64InputStream((InputStream)in, false);
        }
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base64 wrap-wrap-wrap!");
    }

    @Test
    void testCodec101() throws Exception {
        byte[] codec101 = StringUtils.getBytesUtf8((String)"124");
        ByteArrayInputStream bais = new ByteArrayInputStream(codec101);
        try (Base64InputStream in = new Base64InputStream((InputStream)bais);){
            byte[] result = new byte[8192];
            int c = in.read(result);
            Assertions.assertTrue((c > 0 ? 1 : 0) != 0, (String)("Codec101: First read successful [c=" + c + "]"));
            c = in.read(result);
            Assertions.assertTrue((c < 0 ? 1 : 0) != 0, (String)("Codec101: Second read should report end-of-stream [c=" + c + "]"));
        }
    }

    @Test
    void testCodec105() throws IOException {
        try (Base64InputStream in = new Base64InputStream((InputStream)new Codec105ErrorInputStream(), true, 0, null);){
            for (int i = 0; i < 5; ++i) {
                in.read();
            }
        }
    }

    @Test
    void testCodec130() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (Base64OutputStream base64os = new Base64OutputStream((OutputStream)bos);){
            base64os.write(StringUtils.getBytesUtf8((String)STRING_FIXTURE));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        Base64InputStream ins = new Base64InputStream((InputStream)bis);
        ins.skip(1L);
        byte[] decodedBytes = BaseNTestData.streamToBytes((InputStream)ins, new byte[64]);
        String str = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assertions.assertEquals((Object)STRING_FIXTURE.substring(1), (Object)str);
    }

    @Test
    void testCodec98NPE() throws Exception {
        byte[] codec98 = StringUtils.getBytesUtf8((String)"YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXpBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWjAxMjM");
        ByteArrayInputStream data = new ByteArrayInputStream(codec98);
        Base64InputStream stream = new Base64InputStream((InputStream)data);
        byte[] decodedBytes = BaseNTestData.streamToBytes((InputStream)stream, new byte[1024]);
        String decoded = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assertions.assertEquals((Object)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123", (Object)decoded, (String)"codec-98 NPE Base64InputStream");
    }

    @Test
    void testInputStreamReader() throws Exception {
        byte[] codec101 = StringUtils.getBytesUtf8((String)"124");
        ByteArrayInputStream bais = new ByteArrayInputStream(codec101);
        Base64InputStream in = new Base64InputStream((InputStream)bais);
        InputStreamReader isr = new InputStreamReader((InputStream)in);
        try (BufferedReader br = new BufferedReader(isr);){
            String line = br.readLine();
            Assertions.assertNotNull((Object)line, (String)"Codec101:  InputStreamReader works!");
        }
    }

    @Test
    void testMarkSupported() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assertions.assertFalse((boolean)in.markSupported(), (String)"Base64InputStream.markSupported() is false");
        }
    }

    @Test
    void testRead0() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            bytesRead = in.read(buf, 0, 0);
            Assertions.assertEquals((int)0, (int)bytesRead, (String)"Base64InputStream.read(buf, 0, 0) returns 0");
        }
    }

    @Test
    void testReadMultipleBufferSizes() throws Exception {
        byte[][] randomData = BaseNTestData.randomData((BaseNCodec)new Base64(0, null, false), 65536);
        byte[] encoded = randomData[1];
        byte[] decoded = randomData[0];
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (Base64InputStream in = new Base64InputStream((InputStream)bin);){
            for (int i : new int[]{4096, 4096, 8192, 8192, 16384, 16384, 8192}) {
                byte[] buf = new byte[i];
                int bytesRead = in.read(buf);
                Assertions.assertEquals((int)i, (int)bytesRead);
                out.write(buf, 0, bytesRead);
            }
        }
        Assertions.assertArrayEquals((byte[])decoded, (byte[])out.toByteArray());
    }

    @Test
    void testReadNull() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assertions.assertThrows(NullPointerException.class, () -> in.read(null, 0, 0));
        }
    }

    @Test
    void testReadOutOfBounds() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, -1, 0), (String)"Base64InputStream.read(buf, -1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, 0, -1), (String)"Base64InputStream.read(buf, 0, -1)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, buf.length + 1, 0), (String)"Base64InputStream.read(buf, buf.length + 1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, buf.length - 1, 2), (String)"Base64InputStream.read(buf, buf.length - 1, 2)");
        }
    }

    @Test
    void testSkipBig() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assertions.assertEquals((long)6L, (long)b64stream.skip(Integer.MAX_VALUE));
            Assertions.assertEquals((int)-1, (int)b64stream.read());
            Assertions.assertEquals((int)-1, (int)b64stream.read());
        }
    }

    @Test
    void testSkipNone() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            byte[] actualBytes = new byte[6];
            Assertions.assertEquals((long)0L, (long)b64stream.skip(0L));
            b64stream.read(actualBytes, 0, actualBytes.length);
            Assertions.assertArrayEquals((byte[])actualBytes, (byte[])new byte[]{0, 0, 0, -1, -1, -1});
            Assertions.assertEquals((int)-1, (int)b64stream.read());
        }
    }

    @Test
    void testSkipPastEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assertions.assertEquals((long)6L, (long)b64stream.skip(10L));
            Assertions.assertEquals((int)-1, (int)b64stream.read());
            Assertions.assertEquals((int)-1, (int)b64stream.read());
        }
    }

    @Test
    void testSkipToEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assertions.assertEquals((long)6L, (long)b64stream.skip(6L));
            Assertions.assertEquals((int)-1, (int)b64stream.read());
            Assertions.assertEquals((int)-1, (int)b64stream.read());
        }
    }

    @Test
    void testSkipWrongArgument() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> b64stream.skip(-10L));
        }
    }

    @Test
    void testStrictDecoding() throws Exception {
        for (String s : Base64Test.BASE64_IMPOSSIBLE_CASES) {
            byte[] encoded = StringUtils.getBytesUtf8((String)s);
            Base64InputStream in = new Base64InputStream((InputStream)new ByteArrayInputStream(encoded), false);
            Assertions.assertFalse((boolean)in.isStrictDecoding());
            BaseNTestData.streamToBytes((InputStream)in);
            Base64InputStream in2 = new Base64InputStream((InputStream)new ByteArrayInputStream(encoded), false, 0, null, CodecPolicy.STRICT);
            Assertions.assertTrue((boolean)in2.isStrictDecoding());
            Assertions.assertThrows(IllegalArgumentException.class, () -> BaseNTestData.streamToBytes((InputStream)in2));
        }
    }
}

