/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsTest {
    private static final byte[] BYTES_FIXTURE = new byte[]{97, 98, 99};
    private static final byte[] BYTES_FIXTURE_16BE = new byte[]{0, 97, 0, 98, 0, 99};
    private static final byte[] BYTES_FIXTURE_16LE = new byte[]{97, 0, 98, 0, 99, 0};
    private static final String STRING_FIXTURE = "ABC";

    @Test
    public void testByteBufferUtf8() {
        Assertions.assertNull((Object)StringUtils.getByteBufferUtf8(null), (String)"Should be null safe");
        String text = "asdhjfhsadiogasdjhagsdygfjasfgsdaksjdhfk";
        ByteBuffer bb = StringUtils.getByteBufferUtf8((String)"asdhjfhsadiogasdjhagsdygfjasfgsdaksjdhfk");
        Assertions.assertArrayEquals((byte[])"asdhjfhsadiogasdjhagsdygfjasfgsdaksjdhfk".getBytes(StandardCharsets.UTF_8), (byte[])bb.array());
    }

    @Test
    public void testConstructor() {
        new StringUtils();
    }

    @Test
    public void testEqualsCS1() {
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), null));
        Assertions.assertFalse((boolean)StringUtils.equals(null, (CharSequence)new StringBuilder("abc")));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("abc")));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("abcd")));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abcd"), (CharSequence)new StringBuilder("abc")));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder(STRING_FIXTURE)));
    }

    @Test
    public void testEqualsCS2() {
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)new StringBuilder("abc")));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)"abcd"));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)"abcd", (CharSequence)new StringBuilder("abc")));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)new StringBuilder("abc"), (CharSequence)STRING_FIXTURE));
    }

    @Test
    public void testEqualsString() {
        Assertions.assertTrue((boolean)StringUtils.equals(null, null));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)"abc", null));
        Assertions.assertFalse((boolean)StringUtils.equals(null, (CharSequence)"abc"));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)"abcd"));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)"abcd", (CharSequence)"abc"));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)"abc", (CharSequence)STRING_FIXTURE));
    }

    @Test
    public void testGetBytesIso8859_1() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.ISO_8859_1.name();
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesIso8859_1((String)STRING_FIXTURE);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    private void testGetBytesUnchecked(String charsetName) throws UnsupportedEncodingException {
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUnchecked((String)STRING_FIXTURE, (String)charsetName);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testGetBytesUncheckedBadName() {
        Assertions.assertThrows(IllegalStateException.class, () -> StringUtils.getBytesUnchecked((String)STRING_FIXTURE, (String)"UNKNOWN"));
    }

    @Test
    public void testGetBytesUncheckedNullInput() {
        Assertions.assertNull((Object)StringUtils.getBytesUnchecked(null, (String)"UNKNOWN"));
    }

    @Test
    public void testGetBytesUsAscii() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.US_ASCII.name();
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUsAscii((String)STRING_FIXTURE);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testGetBytesUtf16() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_16.name();
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf16((String)STRING_FIXTURE);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testGetBytesUtf16Be() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_16BE.name();
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf16Be((String)STRING_FIXTURE);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testGetBytesUtf16Le() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_16LE.name();
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf16Le((String)STRING_FIXTURE);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testGetBytesUtf8() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_8.name();
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    private void testNewString(String charsetName) throws UnsupportedEncodingException {
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newString((byte[])BYTES_FIXTURE, (String)charsetName);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringBadEnc() {
        Assertions.assertThrows(IllegalStateException.class, () -> StringUtils.newString((byte[])BYTES_FIXTURE, (String)"UNKNOWN"));
    }

    @Test
    public void testNewStringIso8859_1() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.ISO_8859_1.name();
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringIso8859_1((byte[])BYTES_FIXTURE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringNullInput() {
        Assertions.assertNull((Object)StringUtils.newString(null, (String)"UNKNOWN"));
    }

    @Test
    public void testNewStringNullInput_CODEC229() {
        Assertions.assertNull((Object)StringUtils.newStringUtf8(null));
        Assertions.assertNull((Object)StringUtils.newStringIso8859_1(null));
        Assertions.assertNull((Object)StringUtils.newStringUsAscii(null));
        Assertions.assertNull((Object)StringUtils.newStringUtf16(null));
        Assertions.assertNull((Object)StringUtils.newStringUtf16Be(null));
        Assertions.assertNull((Object)StringUtils.newStringUtf16Le(null));
    }

    @Test
    public void testNewStringUsAscii() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.US_ASCII.name();
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUsAscii((byte[])BYTES_FIXTURE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf16() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_16.name();
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUtf16((byte[])BYTES_FIXTURE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf16Be() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_16BE.name();
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE_16BE, charsetName);
        String actual = StringUtils.newStringUtf16Be((byte[])BYTES_FIXTURE_16BE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf16Le() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_16LE.name();
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE_16LE, charsetName);
        String actual = StringUtils.newStringUtf16Le((byte[])BYTES_FIXTURE_16LE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNewStringUtf8() throws UnsupportedEncodingException {
        String charsetName = StandardCharsets.UTF_8.name();
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUtf8((byte[])BYTES_FIXTURE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

