/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base16;
import org.apache.commons.codec.binary.Base16OutputStream;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base16OutputStreamTest {
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testBase16EmptyOutputStream() throws IOException {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded);
        this.testByChunk(emptyEncoded, emptyDecoded);
    }

    @Test
    public void testBase16OutputStreamByChunk() throws IOException {
        byte[] encoded = StringUtils.getBytesUtf8((String)"48656C6C6F20576F726C64");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String)"41");
        decoded = new byte[]{65};
        this.testByChunk(encoded, decoded);
        Base16 codec = new Base16(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, true);
        }
    }

    @Test
    public void testBase16OutputStreamByteByByte() throws IOException {
        byte[] encoded = StringUtils.getBytesUtf8((String)"48656C6C6F20576F726C64");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String)"41");
        decoded = new byte[]{65};
        this.testByteByByte(encoded, decoded);
        Base16 codec = new Base16(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, true);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded) throws IOException {
        this.testByChunk(encoded, decoded, false);
    }

    private void testByChunk(byte[] encoded, byte[] decoded, boolean lowerCase) throws IOException {
        byte[] output;
        Base16OutputStream out;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            out = new Base16OutputStream((OutputStream)byteOut, true, lowerCase);
            try {
                out.write(decoded);
                output = byteOut.toByteArray();
                Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming chunked base16 encode");
            }
            finally {
                out.close();
            }
        }
        byteOut = new ByteArrayOutputStream();
        try {
            out = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            try {
                out.write(encoded);
                output = byteOut.toByteArray();
                Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming chunked base16 decode");
            }
            finally {
                out.close();
            }
        }
        finally {
            byteOut.close();
        }
        byteOut = new ByteArrayOutputStream();
        try (Base16OutputStream decoderOut = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
             Base16OutputStream encoderOut = new Base16OutputStream((OutputStream)decoderOut, true, lowerCase);){
            encoderOut.write(decoded);
            byte[] output2 = byteOut.toByteArray();
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output2, (String)"Streaming chunked base16 wrap-wrap!");
        }
        finally {
            byteOut.close();
        }
    }

    private void testByteByByte(byte[] encoded, byte[] decoded) throws IOException {
        this.testByteByByte(encoded, decoded, false);
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, boolean lowerCase) throws IOException {
        byte[] output;
        Base16OutputStream out;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            out = new Base16OutputStream((OutputStream)byteOut, true, lowerCase);
            try {
                for (byte element : decoded) {
                    out.write(element);
                }
                output = byteOut.toByteArray();
                Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming byte-by-byte base16 encode");
            }
            finally {
                out.close();
            }
        }
        byteOut = new ByteArrayOutputStream();
        try {
            out = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            try {
                for (byte element : encoded) {
                    out.write(element);
                }
                output = byteOut.toByteArray();
                Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming byte-by-byte base16 decode");
            }
            finally {
                out.close();
            }
        }
        finally {
            byteOut.close();
        }
        byteOut = new ByteArrayOutputStream();
        try {
            out = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            try {
                for (byte element : encoded) {
                    out.write(element);
                    out.flush();
                }
                output = byteOut.toByteArray();
                Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming byte-by-byte flush() base16 decode");
            }
            finally {
                out.close();
            }
        }
        finally {
            byteOut.close();
        }
        byteOut = new ByteArrayOutputStream();
        try (Base16OutputStream decoderOut = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
             Base16OutputStream encoderOut = new Base16OutputStream((OutputStream)decoderOut, true, lowerCase);){
            for (byte element : decoded) {
                encoderOut.write(element);
            }
            byte[] output2 = byteOut.toByteArray();
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output2, (String)"Streaming byte-by-byte base16 wrap-wrap!");
        }
        finally {
            byteOut.close();
        }
    }

    @Test
    public void testWriteOutOfBounds() throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (Base16OutputStream out = new Base16OutputStream((OutputStream)bout);){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, -1, 1), (String)"Base16InputStream.write(buf, -1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, 1, -1), (String)"Base16InputStream.write(buf, 1, -1)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, buf.length + 1, 0), (String)"Base16InputStream.write(buf, buf.length + 1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> out.write(buf, buf.length - 1, 2), (String)"Base16InputStream.write(buf, buf.length - 1, 2)");
        }
    }

    @Test
    public void testWriteToNullCoverage() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (Base16OutputStream out = new Base16OutputStream((OutputStream)bout);){
            Assertions.assertThrows(NullPointerException.class, () -> out.write(null, 0, 0));
        }
    }
}

