/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.stream.Stream;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class LanguageGuessingTest {
    private final Lang lang = Lang.instance((NameType)NameType.GENERIC);

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Renault", "french"}), Arguments.of((Object[])new Object[]{"Mickiewicz", "polish"}), Arguments.of((Object[])new Object[]{"Thompson", "english"}), Arguments.of((Object[])new Object[]{"Nu\u00f1ez", "spanish"}), Arguments.of((Object[])new Object[]{"Carvalho", "portuguese"}), Arguments.of((Object[])new Object[]{"\u010capek", "czech"}), Arguments.of((Object[])new Object[]{"Sjneijder", "dutch"}), Arguments.of((Object[])new Object[]{"Klausewitz", "german"}), Arguments.of((Object[])new Object[]{"K\u00fc\u00e7\u00fck", "turkish"}), Arguments.of((Object[])new Object[]{"Giacometti", "italian"}), Arguments.of((Object[])new Object[]{"Nagy", "hungarian"}), Arguments.of((Object[])new Object[]{"Ceau\u015fescu", "romanian"}), Arguments.of((Object[])new Object[]{"Angelopoulos", "greeklatin"}), Arguments.of((Object[])new Object[]{"\u0391\u03b3\u03b3\u03b5\u03bb\u03cc\u03c0\u03bf\u03c5\u03bb\u03bf\u03c2", "greek"}), Arguments.of((Object[])new Object[]{"\u041f\u0443\u0448\u043a\u0438\u043d", "cyrillic"}), Arguments.of((Object[])new Object[]{"\u05db\u05d4\u05df", "hebrew"}), Arguments.of((Object[])new Object[]{"\u00e1cz", "any"}), Arguments.of((Object[])new Object[]{"\u00e1tz", "any"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLanguageGuessing(String name, String language) {
        Languages.LanguageSet guesses = this.lang.guessLanguages(name);
        Assertions.assertTrue((boolean)guesses.contains(language), (String)("language predicted for name '" + name + "' is wrong: " + guesses + " should contain '" + language + "'"));
    }
}

