/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.language.MatchRatingApproachEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MatchRatingApproachEncoderTest
extends AbstractStringEncoderTest<MatchRatingApproachEncoder> {
    @Override
    protected MatchRatingApproachEncoder createStringEncoder() {
        return new MatchRatingApproachEncoder();
    }

    @Test
    public final void testAccentRemoval_AllLower_SuccessfullyRemoved() {
        Assertions.assertEquals((Object)"aeiou", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("\u00e1\u00e9\u00ed\u00f3\u00fa"));
    }

    @Test
    public final void testAccentRemoval_ComprehensiveAccentMix_AllSuccessfullyRemoved() {
        Assertions.assertEquals((Object)"E,E,E,E,U,U,I,I,A,A,O,e,e,e,e,u,u,i,i,a,a,o,c", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("\u00c8,\u00c9,\u00ca,\u00cb,\u00db,\u00d9,\u00cf,\u00ce,\u00c0,\u00c2,\u00d4,\u00e8,\u00e9,\u00ea,\u00eb,\u00fb,\u00f9,\u00ef,\u00ee,\u00e0,\u00e2,\u00f4,\u00e7"));
    }

    @Test
    public final void testAccentRemoval_GerSpanFrenMix_SuccessfullyRemoved() {
        Assertions.assertEquals((Object)"aeou\u00dfAEOUnNa", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("\u00e4\u00eb\u00f6\u00fc\u00df\u00c4\u00cb\u00d6\u00dc\u00f1\u00d1\u00e0"));
    }

    @Test
    public final void testAccentRemoval_MixedWithUnusualChars_SuccessfullyRemovedAndUnusualCharactersInvariant() {
        Assertions.assertEquals((Object)"A-e'i.,o&u", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("\u00c1-e'\u00ed.,\u00f3&\u00fa"));
    }

    @Test
    public final void testAccentRemoval_NINO_NoChange() {
        Assertions.assertEquals((Object)"", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents(""));
    }

    @Test
    public final void testAccentRemoval_NullValue_ReturnNullSuccessfully() {
        Assertions.assertNull((Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents(null));
    }

    @Test
    public final void testAccentRemoval_UpperAndLower_SuccessfullyRemovedAndCaseInvariant() {
        Assertions.assertEquals((Object)"AeiOuu", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("\u00c1e\u00ed\u00d3uu"));
    }

    @Test
    public final void testAccentRemoval_WithSpaces_SuccessfullyRemovedAndSpacesInvariant() {
        Assertions.assertEquals((Object)"ae io  u", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("\u00e1\u00e9 \u00ed\u00f3  \u00fa"));
    }

    @Test
    public final void testAccentRemovalNormalString_NoChange() {
        Assertions.assertEquals((Object)"Colorless green ideas sleep furiously", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeAccents("Colorless green ideas sleep furiously"));
    }

    @Test
    public final void testCleanName_SuccessfullyClean() {
        Assertions.assertEquals((Object)"THISISATEST", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).cleanName("This-\u00eds   a t.,es &t"));
    }

    @Test
    public final void testCompare_BRIAN_BRYAN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Brian", "Bryan"));
    }

    @Test
    public final void testCompare_BURNS_BOURNE_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Burns", "Bourne"));
    }

    @Test
    public final void testCompare_CATHERINE_KATHRYN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Catherine", "Kathryn"));
    }

    @Test
    public final void testCompare_COLM_COLIN_WithAccentsAndSymbolsAndSpaces_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("C\u00f3lm.   ", "C-ol\u00edn"));
    }

    @Test
    public final void testCompare_Forenames_SEAN_JOHN_MatchExpected() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Sean", "John"));
    }

    @Test
    public final void testCompare_Forenames_SEAN_PETE_NoMatchExpected() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Sean", "Pete"));
    }

    @Test
    public final void testCompare_Forenames_UNA_OONAGH_ShouldSuccessfullyMatchButDoesNot() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("\u00dana", "Oonagh"));
    }

    @Test
    public final void testCompare_FRANCISZEK_FRANCES_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Franciszek", "Frances"));
    }

    @Test
    public final void testCompare_KARL_ALESSANDRO_DoesNotMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Karl", "Alessandro"));
    }

    @Test
    public final void testCompare_LongSurnames_MORIARTY_OMUIRCHEARTAIGH_DoesNotSuccessfulMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Moriarty", "OMuircheartaigh"));
    }

    @Test
    public final void testCompare_LongSurnames_OMUIRCHEARTAIGH_OMIREADHAIGH_SuccessfulMatch() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("o'muireadhaigh", "\u00d3 'Muircheartaigh "));
    }

    @Test
    public final void testCompare_MCGOWAN_MCGEOGHEGAN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("McGowan", "Mc Geoghegan"));
    }

    @Test
    public final void testCompare_MICKY_MICHAEL_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Micky", "Michael"));
    }

    @Test
    public final void testCompare_OONA_OONAGH_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Oona", "Oonagh"));
    }

    @Test
    public final void testCompare_PETERSON_PETERS_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Peterson", "Peters"));
    }

    @Test
    public final void testCompare_SAM_SAMUEL_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Sam", "Samuel"));
    }

    @Test
    public final void testCompare_SEAN_SHAUN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("S\u00e9an", "Shaun"));
    }

    @Test
    public final void testCompare_ShortNames_AL_ED_WorksButNoMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Al", "Ed"));
    }

    @Test
    public final void testCompare_SmallInput_CARK_Kl_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Kl", "Karl"));
    }

    @Test
    public final void testCompare_SMITH_SMYTH_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("smith", "smyth"));
    }

    @Test
    public final void testCompare_SOPHIE_SOFIA_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Sophie", "Sofia"));
    }

    @Test
    public final void testCompare_STEPHEN_STEFAN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Stephen", "Stefan"));
    }

    @Test
    public final void testCompare_STEPHEN_STEVEN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Stephen", "Steven"));
    }

    @Test
    public final void testCompare_STEVEN_STEFAN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Steven", "Stefan"));
    }

    @Test
    public final void testCompare_Surname_AUERBACH_UHRBACH_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Auerbach", "Uhrbach"));
    }

    @Test
    public final void testCompare_Surname_COOPERFLYNN_SUPERLYN_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Cooper-Flynn", "Super-Lyn"));
    }

    @Test
    public final void testCompare_Surname_HAILEY_HALLEY_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Hailey", "Halley"));
    }

    @Test
    public final void testCompare_Surname_LEWINSKY_LEVINSKI_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("LEWINSKY", "LEVINSKI"));
    }

    @Test
    public final void testCompare_Surname_LIPSHITZ_LIPPSZYC_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("LIPSHITZ", "LIPPSZYC"));
    }

    @Test
    public final void testCompare_Surname_MOSKOWITZ_MOSKOVITZ_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Moskowitz", "Moskovitz"));
    }

    @Test
    public final void testCompare_Surname_OSULLIVAN_OSUILLEABHAIN_SuccessfulMatch() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("O'Sullivan", "\u00d3 ' S\u00failleabh\u00e1in"));
    }

    @Test
    public final void testCompare_Surname_PRZEMYSL_PSHEMESHIL_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals(" P rz e m y s l", " P sh e m e sh i l"));
    }

    @Test
    public final void testCompare_Surname_ROSOCHOWACIEC_ROSOKHOVATSETS_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("R o s o ch o w a c ie c", " R o s o k ho v a ts e ts"));
    }

    @Test
    public final void testCompare_Surname_SZLAMAWICZ_SHLAMOVITZ_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("SZLAMAWICZ", "SHLAMOVITZ"));
    }

    @Test
    public final void testCompare_SurnameCornerCase_Nulls_NoMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals(null, null));
    }

    @Test
    public final void testCompare_Surnames_MURPHY_LYNCH_NoMatchExpected() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Murphy", "Lynch"));
    }

    @Test
    public final void testCompare_SurnamesCornerCase_MURPHY_NoSpace_NoMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Murphy", ""));
    }

    @Test
    public final void testCompare_SurnamesCornerCase_MURPHY_Space_NoMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Murphy", " "));
    }

    @Test
    public final void testCompare_TOMASZ_TOM_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Tomasz", "tom"));
    }

    @Test
    public final void testCompare_ZACH_ZAKARIA_SuccessfullyMatched() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Zach", "Zacharia"));
    }

    @Test
    public final void testCompareNameNullSpace_ReturnsFalseSuccessfully() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals(null, " "));
    }

    @Test
    public final void testCompareNameSameNames_ReturnsFalseSuccessfully() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("John", "John"));
    }

    @Test
    public final void testCompareNameToSingleLetter_KARL_C_DoesNotMatch() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("Karl", "C"));
    }

    @Test
    public final void testGetEncoding_HARPER_HRPR() {
        Assertions.assertEquals((Object)"HRPR", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode("HARPER"));
    }

    @Test
    public final void testGetEncoding_NoSpace_to_Nothing() {
        Assertions.assertEquals((Object)"", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode(""));
    }

    @Test
    public final void testGetEncoding_Null_to_Nothing() {
        Assertions.assertEquals((Object)"", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode(null));
    }

    @Test
    public final void testGetEncoding_One_Letter_to_Nothing() {
        Assertions.assertEquals((Object)"", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode("E"));
    }

    @Test
    public final void testGetEncoding_SMITH_to_SMTH() {
        Assertions.assertEquals((Object)"SMTH", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode("Smith"));
    }

    @Test
    public final void testGetEncoding_SMYTH_to_SMYTH() {
        Assertions.assertEquals((Object)"SMYTH", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode("Smyth"));
    }

    @Test
    public final void testGetEncoding_Space_to_Nothing() {
        Assertions.assertEquals((Object)"", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode(" "));
    }

    @Test
    public final void testGetFirstLast3__ALEXANDER_Returns_Aleder() {
        Assertions.assertEquals((Object)"Aleder", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).getFirst3Last3("Alexzander"));
    }

    @Test
    public final void testGetFirstLast3_PETE_Returns_PETE() {
        Assertions.assertEquals((Object)"PETE", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).getFirst3Last3("PETE"));
    }

    @Test
    public final void testGetMinRating_1_Returns5_Successfully() {
        Assertions.assertEquals((int)5, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(1));
    }

    @Test
    public final void testgetMinRating_10_Returns3_Successfully() {
        Assertions.assertEquals((int)3, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(10));
    }

    @Test
    public final void testgetMinRating_11_Returns_3_Successfully() {
        Assertions.assertEquals((int)3, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(11));
    }

    @Test
    public final void testGetMinRating_13_Returns_1_Successfully() {
        Assertions.assertEquals((int)1, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(13));
    }

    @Test
    public final void testGetMinRating_2_Returns5_Successfully() {
        Assertions.assertEquals((int)5, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(2));
    }

    @Test
    public final void testgetMinRating_5_Returns4_Successfully() {
        Assertions.assertEquals((int)4, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(5));
    }

    @Test
    public final void testgetMinRating_5_Returns4_Successfully2() {
        Assertions.assertEquals((int)4, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(5));
    }

    @Test
    public final void testgetMinRating_6_Returns4_Successfully() {
        Assertions.assertEquals((int)4, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(6));
    }

    @Test
    public final void testGetMinRating_7_Return4_Successfully() {
        Assertions.assertEquals((int)4, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(7));
    }

    @Test
    public final void testgetMinRating_7_Returns4_Successfully() {
        Assertions.assertEquals((int)4, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(7));
    }

    @Test
    public final void testgetMinRating_8_Returns3_Successfully() {
        Assertions.assertEquals((int)3, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).getMinRating(8));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_FirstNameJust1Letter_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("t", "test"));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_FirstNameJustSpace_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals(" ", "test"));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_FirstNameNothing_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("", "test"));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_FirstNameNull_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals(null, "test"));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_SecondNameJustSpace_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("test", " "));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_SecondNameNothing_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("test", ""));
    }

    @Test
    public final void testIsEncodeEquals_CornerCase_SecondNameNull_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("test", null));
    }

    @Test
    public final void testIsEncodeEqualsSecondNameJust1Letter_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isEncodeEquals("test", "t"));
    }

    @Test
    public final void testIsVowel_CapitalA_ReturnsTrue() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isVowel("A"));
    }

    @Test
    public final void testIsVowel_SingleVowel_ReturnsTrue() {
        Assertions.assertTrue((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isVowel("I"));
    }

    @Test
    public final void testIsVowel_SmallD_ReturnsFalse() {
        Assertions.assertFalse((boolean)((MatchRatingApproachEncoder)this.getStringEncoder()).isVowel("d"));
    }

    @Test
    public final void testLeftToRightThenRightToLeft_ALEXANDER_ALEXANDRA_Returns4() {
        Assertions.assertEquals((int)4, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).leftToRightThenRightToLeftProcessing("ALEXANDER", "ALEXANDRA"));
    }

    @Test
    public final void testLeftToRightThenRightToLeft_EINSTEIN_MICHAELA_Returns0() {
        Assertions.assertEquals((int)0, (int)((MatchRatingApproachEncoder)this.getStringEncoder()).leftToRightThenRightToLeftProcessing("EINSTEIN", "MICHAELA"));
    }

    @Test
    public final void testPunctuationOnly() {
        Assertions.assertEquals((Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode(".,-"), (Object)"");
    }

    @Test
    public final void testRemoveDoubleConsonants_MISSISSIPPI_RemovedSuccessfully() {
        Assertions.assertEquals((Object)"MISISIPI", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeDoubleConsonants("MISSISSIPPI"));
    }

    @Test
    public final void testRemoveDoubleDoubleVowel_BEETLE_NotRemoved() {
        Assertions.assertEquals((Object)"BEETLE", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeDoubleConsonants("BEETLE"));
    }

    @Test
    public final void testRemoveSingleDoubleConsonants_BUBLE_RemovedSuccessfully() {
        Assertions.assertEquals((Object)"BUBLE", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeDoubleConsonants("BUBBLE"));
    }

    @Test
    public final void testRemoveVowel__AIDAN_Returns_ADN() {
        Assertions.assertEquals((Object)"ADN", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeVowels("AIDAN"));
    }

    @Test
    public final void testRemoveVowel__DECLAN_Returns_DCLN() {
        Assertions.assertEquals((Object)"DCLN", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeVowels("DECLAN"));
    }

    @Test
    public final void testRemoveVowel_ALESSANDRA_Returns_ALSSNDR() {
        Assertions.assertEquals((Object)"ALSSNDR", (Object)((MatchRatingApproachEncoder)this.getStringEncoder()).removeVowels("ALESSANDRA"));
    }

    @Test
    public final void testVowelAndPunctuationOnly() {
        Assertions.assertEquals((Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode("uoiea.,-AEIOU"), (Object)"U");
    }

    @Test
    public final void testVowelOnly() {
        Assertions.assertEquals((Object)((MatchRatingApproachEncoder)this.getStringEncoder()).encode("aeiouAEIOU"), (Object)"A");
    }
}

