/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacAlgorithmsTest;
import org.apache.commons.codec.digest.HmacUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HmacUtilsTest {
    @Test
    public void testEmptyKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.getHmacMd5((byte[])new byte[0]));
    }

    @Test
    public void testGetHMac() {
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.getHmacMd5((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.getHmacSha256((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.getHmacSha384((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.getHmacSha512((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }

    @Test
    public void testHmacMd5Hex() throws IOException {
        Assertions.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)"750c783e6ab0b503eaa86e310a5db738", (Object)HmacUtils.hmacMd5Hex((String)"Jefe", (String)"what do ya want for nothing?"));
        Assertions.assertEquals((Object)"750c783e6ab0b503eaa86e310a5db738", (Object)HmacUtils.hmacMd5Hex((byte[])"Jefe".getBytes(), (InputStream)new ByteArrayInputStream("what do ya want for nothing?".getBytes())));
    }

    @Test
    public void testHmacSha1Hex() throws IOException {
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)HmacUtils.hmacSha1Hex((String)"key", (String)""));
        Assertions.assertEquals((Object)"effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", (Object)HmacUtils.hmacSha1Hex((String)"Jefe", (String)"what do ya want for nothing?"));
        Assertions.assertEquals((Object)"effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", (Object)HmacUtils.hmacSha1Hex((byte[])"Jefe".getBytes(), (InputStream)new ByteArrayInputStream("what do ya want for nothing?".getBytes())));
    }

    @Test
    public void testHmacSha1UpdateWithByteArray() {
        Mac mac = HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        HmacUtils.updateHmac((Mac)mac, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
        HmacUtils.updateHmac((Mac)mac, (byte[])"".getBytes());
        Assertions.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
    }

    @Test
    public void testHmacSha1UpdateWithInputStream() throws IOException {
        Mac mac = HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        HmacUtils.updateHmac((Mac)mac, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
        HmacUtils.updateHmac((Mac)mac, (InputStream)new ByteArrayInputStream("".getBytes()));
        Assertions.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
    }

    @Test
    public void testHmacSha1UpdateWithString() {
        Mac mac = HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        HmacUtils.updateHmac((Mac)mac, (String)"The quick brown fox jumps over the lazy dog");
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
        HmacUtils.updateHmac((Mac)mac, (String)"");
        Assertions.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
    }

    @Test
    public void testInitializedMac() {
        Mac md5Mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_MD5, (byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        Mac md5Mac2 = HmacUtils.getInitializedMac((String)"HmacMD5", (byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.updateHmac((Mac)md5Mac, (String)"The quick brown fox jumps over the lazy dog").doFinal());
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.updateHmac((Mac)md5Mac2, (String)"The quick brown fox jumps over the lazy dog").doFinal());
    }

    @Test
    public void testInitializedMacNullAlgo() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.getInitializedMac((String)null, (byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES));
    }

    @Test
    public void testInitializedMacNullKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_MD5, null));
    }

    @Test
    public void testInternalNoSuchAlgorithmException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.getInitializedMac((String)"Bogus Bogus", (byte[])StringUtils.getBytesUtf8((String)"akey")));
    }

    @Test
    public void testMd5HMac() throws IOException {
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.hmacMd5((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.hmacMd5((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.hmacMd5((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test
    public void testMd5HMacFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.hmacMd5((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }

    @Test
    public void testNullKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.getHmacMd5(null));
    }

    @Test
    public void testSecretKeySpecAllowsEmptyKeys() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SecretKeySpec(new byte[0], "HmacMD5"));
    }

    @Test
    public void testSha1HMac() throws IOException {
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.hmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.hmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.hmacSha1((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test
    public void testSha1HMacFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.hmacSha1((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }

    @Test
    public void testSha256HMac() throws IOException {
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.hmacSha256((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.hmacSha256((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.hmacSha256((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)"f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", (Object)HmacUtils.hmacSha256Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertEquals((Object)"f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", (Object)HmacUtils.hmacSha256Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertEquals((Object)"f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", (Object)HmacUtils.hmacSha256Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test
    public void testSha256HMacFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.hmacSha256((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }

    @Test
    public void testSha384HMac() throws IOException {
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.hmacSha384((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.hmacSha384((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.hmacSha384((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA384_RESULT_STRING, (Object)HmacUtils.hmacSha384Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA384_RESULT_STRING, (Object)HmacUtils.hmacSha384Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA384_RESULT_STRING, (Object)HmacUtils.hmacSha384Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test
    public void testSha384HMacFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.hmacSha384((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }

    @Test
    public void testSha512HMac() throws IOException {
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.hmacSha512((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.hmacSha512((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.hmacSha512((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assertions.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA512_RESULT_STRING, (Object)HmacUtils.hmacSha512Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assertions.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA512_RESULT_STRING, (Object)HmacUtils.hmacSha512Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assertions.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA512_RESULT_STRING, (Object)HmacUtils.hmacSha512Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test
    public void testSha512HMacFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HmacUtils.hmacSha512((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }
}

