/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base16;
import org.apache.commons.codec.binary.Base16InputStream;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base16InputStreamTest {
    private static final String ENCODED_B16 = "CAFEBABEFFFF";
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testAvailable() throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B16));
        try (Base16InputStream b16Stream = new Base16InputStream((InputStream)ins);){
            Assertions.assertEquals((int)1, (int)b16Stream.available());
            Assertions.assertEquals((long)6L, (long)b16Stream.skip(10L));
            Assertions.assertEquals((int)0, (int)b16Stream.available());
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
            Assertions.assertEquals((int)0, (int)b16Stream.available());
        }
    }

    @Test
    public void testBase16EmptyInputStream() throws IOException {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded);
        this.testByChunk(emptyEncoded, emptyDecoded);
    }

    @Test
    public void testBase16InputStreamByChunk() throws IOException {
        byte[] encoded = StringUtils.getBytesUtf8((String)"48656C6C6F20576F726C64");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String)"41");
        decoded = new byte[]{65};
        this.testByChunk(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String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
        decoded = BaseNTestData.DECODED;
        this.testByChunk(encoded, decoded);
        Base16 codec = new Base16(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, true);
        }
    }

    @Test
    public void testBase16InputStreamByteByByte() throws IOException {
        byte[] encoded = StringUtils.getBytesUtf8((String)"48656C6C6F20576F726C64");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String)"41");
        decoded = new byte[]{65};
        this.testByteByByte(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String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
        decoded = BaseNTestData.DECODED;
        this.testByteByByte(encoded, decoded);
        Base16 codec = new Base16(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, true);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded) throws IOException {
        this.testByChunk(encoded, decoded, false);
    }

    private void testByChunk(byte[] encoded, byte[] decoded, boolean lowerCase) throws IOException {
        byte[] output;
        try (Object in = new Base16InputStream((InputStream)new ByteArrayInputStream(decoded), true, lowerCase);){
            output = BaseNTestData.streamToBytes((InputStream)in);
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming Base16 encode");
        }
        in = new Base16InputStream((InputStream)new ByteArrayInputStream(encoded), false, lowerCase);
        try {
            output = BaseNTestData.streamToBytes((InputStream)in);
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming Base16 decode");
        }
        finally {
            ((InputStream)in).close();
        }
        in = new ByteArrayInputStream(decoded);
        try (Base16InputStream inEncode = new Base16InputStream((InputStream)in, true, lowerCase);
             Base16InputStream inDecode = new Base16InputStream((InputStream)inEncode, false, lowerCase);){
            byte[] output2 = BaseNTestData.streamToBytes((InputStream)inDecode);
            Assertions.assertEquals((int)-1, (int)inDecode.read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)inDecode.read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output2, (String)"Streaming Base16 wrap-wrap!");
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void testByteByByte(byte[] encoded, byte[] decoded) throws IOException {
        this.testByteByByte(encoded, decoded, false);
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, boolean lowerCase) throws IOException {
        int i;
        byte[] output;
        try (Object in = new Base16InputStream((InputStream)new ByteArrayInputStream(decoded), true, lowerCase);){
            output = new byte[encoded.length];
            for (i = 0; i < output.length; ++i) {
                output[i] = (byte)((InputStream)in).read();
            }
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming Base16 encode");
        }
        in = new Base16InputStream((InputStream)new ByteArrayInputStream(encoded), false, lowerCase);
        try {
            output = new byte[decoded.length];
            for (i = 0; i < output.length; ++i) {
                output[i] = (byte)((InputStream)in).read();
            }
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming Base16 decode");
        }
        finally {
            ((InputStream)in).close();
        }
        in = new ByteArrayInputStream(decoded);
        try (Base16InputStream inEncode = new Base16InputStream((InputStream)in, true, lowerCase);
             Base16InputStream inDecode = new Base16InputStream((InputStream)inEncode, false, lowerCase);){
            byte[] output2 = new byte[decoded.length];
            for (int i2 = 0; i2 < output2.length; ++i2) {
                output2[i2] = (byte)inDecode.read();
            }
            Assertions.assertEquals((int)-1, (int)inDecode.read(), (String)"EOF");
            Assertions.assertEquals((int)-1, (int)inDecode.read(), (String)"Still EOF");
            Assertions.assertArrayEquals((byte[])decoded, (byte[])output2, (String)"Streaming Base16 wrap-wrap!");
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Test
    public void testMarkSupported() throws IOException {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base16InputStream in = new Base16InputStream((InputStream)bin, true);){
            Assertions.assertFalse((boolean)in.markSupported(), (String)"Base16InputStream.markSupported() is false");
        }
    }

    @Test
    public void testRead0() throws IOException {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base16InputStream in = new Base16InputStream((InputStream)bin, true);){
            bytesRead = in.read(buf, 0, 0);
            Assertions.assertEquals((int)0, (int)bytesRead, (String)"Base16InputStream.read(buf, 0, 0) returns 0");
        }
    }

    @Test
    public void testReadNull() throws IOException {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base16InputStream in = new Base16InputStream((InputStream)bin, true);){
            Assertions.assertThrows(NullPointerException.class, () -> in.read(null, 0, 0), (String)"Base16InputStream.read(null, 0, 0)");
        }
    }

    @Test
    public void testReadOutOfBounds() throws IOException {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base16InputStream in = new Base16InputStream((InputStream)bin, true);){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, -1, 0), (String)"Base16InputStream.read(buf, -1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, 0, -1), (String)"Base16InputStream.read(buf, 0, -1)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, buf.length + 1, 0), (String)"Base16InputStream.read(buf, buf.length + 1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, buf.length - 1, 2), (String)"Base16InputStream.read(buf, buf.length - 1, 2)");
        }
    }

    @Test
    public void testSkipBig() throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B16));
        try (Base16InputStream b16Stream = new Base16InputStream((InputStream)ins);){
            Assertions.assertEquals((long)6L, (long)b16Stream.skip(Integer.MAX_VALUE));
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
        }
    }

    @Test
    public void testSkipNone() throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B16));
        try (Base16InputStream b16Stream = new Base16InputStream((InputStream)ins);){
            byte[] actualBytes = new byte[6];
            Assertions.assertEquals((long)0L, (long)b16Stream.skip(0L));
            b16Stream.read(actualBytes, 0, actualBytes.length);
            Assertions.assertArrayEquals((byte[])actualBytes, (byte[])new byte[]{-54, -2, -70, -66, -1, -1});
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
        }
    }

    @Test
    public void testSkipPastEnd() throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B16));
        try (Base16InputStream b16Stream = new Base16InputStream((InputStream)ins);){
            Assertions.assertEquals((long)6L, (long)b16Stream.skip(10L));
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
        }
    }

    @Test
    public void testSkipToEnd() throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B16));
        try (Base16InputStream b16Stream = new Base16InputStream((InputStream)ins);){
            Assertions.assertEquals((long)6L, (long)b16Stream.skip(6L));
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
            Assertions.assertEquals((int)-1, (int)b16Stream.read());
        }
    }

    @Test
    public void testSkipWrongArgument() throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B16));
        try (Base16InputStream b16Stream = new Base16InputStream((InputStream)ins);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> b16Stream.skip(-10L));
        }
    }
}

