/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuotedPrintableCodecTest {
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assertions.assertEquals((Object)"=D0=92=D1=81=D0=B5=D0=BC_=D0=BF=D1=80=D0=B8=D0=B2=D0=B5=D1=82", (Object)qpcodec.encode(ru_msg, "UTF-8"));
        Assertions.assertEquals((Object)"Gr=C3=BCezi_z=C3=A4m=C3=A4", (Object)qpcodec.encode(ch_msg, "UTF-8"));
        Assertions.assertEquals((Object)ru_msg, (Object)qpcodec.decode(qpcodec.encode(ru_msg, "UTF-8"), "UTF-8"));
        Assertions.assertEquals((Object)ch_msg, (Object)qpcodec.decode(qpcodec.encode(ch_msg, "UTF-8"), "UTF-8"));
    }

    @Test
    public void testBasicEncodeDecode() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "= Hello there =\r\n";
        String encoded = qpcodec.encode("= Hello there =\r\n");
        Assertions.assertEquals((Object)"=3D Hello there =3D=0D=0A", (Object)encoded, (String)"Basic quoted-printable encoding test");
        Assertions.assertEquals((Object)"= Hello there =\r\n", (Object)qpcodec.decode(encoded), (String)"Basic quoted-printable decoding test");
    }

    @Test
    public void testSafeCharEncodeDecode() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]";
        String encoded = qpcodec.encode("abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]");
        Assertions.assertEquals((Object)"abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]", (Object)encoded, (String)"Safe chars quoted-printable encoding test");
        Assertions.assertEquals((Object)"abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]", (Object)qpcodec.decode(encoded), (String)"Safe chars quoted-printable decoding test");
    }

    @Test
    public void testUnsafeEncodeDecode() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "=\r\n";
        String encoded = qpcodec.encode("=\r\n");
        Assertions.assertEquals((Object)"=3D=0D=0A", (Object)encoded, (String)"Unsafe chars quoted-printable encoding test");
        Assertions.assertEquals((Object)"=\r\n", (Object)qpcodec.decode(encoded), (String)"Unsafe chars quoted-printable decoding test");
    }

    @Test
    public void testEncodeDecodeNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assertions.assertNull((Object)qpcodec.encode((String)null), (String)"Null string quoted-printable encoding test");
        Assertions.assertNull((Object)qpcodec.decode((String)null), (String)"Null string quoted-printable decoding test");
    }

    @Test
    public void testDecodeInvalid() {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assertions.assertThrows(DecoderException.class, () -> qpcodec.decode("="));
        Assertions.assertThrows(DecoderException.class, () -> qpcodec.decode("=A"));
        Assertions.assertThrows(DecoderException.class, () -> qpcodec.decode("=WW"));
    }

    @Test
    public void testEncodeNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        byte[] plain = null;
        byte[] encoded = qpcodec.encode(plain);
        Assertions.assertNull((Object)encoded, (String)"Encoding a null string should return null");
    }

    @Test
    public void testEncodeUrlWithNullBitSet() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "1+1 = 2";
        String encoded = new String(QuotedPrintableCodec.encodeQuotedPrintable(null, (byte[])"1+1 = 2".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)"1+1 =3D 2", (Object)encoded, (String)"Basic quoted-printable encoding test");
        Assertions.assertEquals((Object)"1+1 = 2", (Object)qpcodec.decode(encoded), (String)"Basic quoted-printable decoding test");
    }

    @Test
    public void testDecodeWithNullArray() throws Exception {
        byte[] plain = null;
        byte[] result = QuotedPrintableCodec.decodeQuotedPrintable(plain);
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    public void testEncodeStringWithNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String test = null;
        String result = qpcodec.encode(test, "charset");
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    public void testDecodeStringWithNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String test = null;
        String result = qpcodec.decode(test, "charset");
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    public void testEncodeObjects() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "1+1 = 2";
        String encoded = (String)qpcodec.encode((Object)"1+1 = 2");
        Assertions.assertEquals((Object)"1+1 =3D 2", (Object)encoded, (String)"Basic quoted-printable encoding test");
        byte[] plainBA = "1+1 = 2".getBytes(StandardCharsets.UTF_8);
        byte[] encodedBA = (byte[])qpcodec.encode((Object)plainBA);
        encoded = new String(encodedBA);
        Assertions.assertEquals((Object)"1+1 =3D 2", (Object)encoded, (String)"Basic quoted-printable encoding test");
        Object result = qpcodec.encode(null);
        Assertions.assertNull((Object)result, (String)"Encoding a null Object should return null");
        Assertions.assertThrows(EncoderException.class, () -> qpcodec.encode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
    }

    @Test
    public void testInvalidEncoding() {
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> new QuotedPrintableCodec("NONSENSE"));
    }

    @Test
    public void testDecodeObjects() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "1+1 =3D 2";
        String decoded = (String)qpcodec.decode((Object)"1+1 =3D 2");
        Assertions.assertEquals((Object)"1+1 = 2", (Object)decoded, (String)"Basic quoted-printable decoding test");
        byte[] plainBA = "1+1 =3D 2".getBytes(StandardCharsets.UTF_8);
        byte[] decodedBA = (byte[])qpcodec.decode((Object)plainBA);
        decoded = new String(decodedBA);
        Assertions.assertEquals((Object)"1+1 = 2", (Object)decoded, (String)"Basic quoted-printable decoding test");
        Object result = qpcodec.decode(null);
        Assertions.assertNull((Object)result, (String)"Decoding a null Object should return null");
        Assertions.assertThrows(DecoderException.class, () -> qpcodec.decode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
    }

    @Test
    public void testDefaultEncoding() throws Exception {
        String plain = "Hello there!";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec("UnicodeBig");
        qpcodec.encode("Hello there!");
        String encoded1 = qpcodec.encode("Hello there!", "UnicodeBig");
        String encoded2 = qpcodec.encode("Hello there!");
        Assertions.assertEquals((Object)encoded1, (Object)encoded2);
    }

    @Test
    public void testSoftLineBreakDecode() throws Exception {
        String qpdata = "If you believe that truth=3Dbeauty, then surely=20=\r\nmathematics is the most beautiful branch of philosophy.";
        String expected = "If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assertions.assertEquals((Object)"If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.", (Object)qpcodec.decode("If you believe that truth=3Dbeauty, then surely=20=\r\nmathematics is the most beautiful branch of philosophy."));
        String encoded = qpcodec.encode("If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.");
        Assertions.assertEquals((Object)"If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testSoftLineBreakEncode() throws Exception {
        String qpdata = "If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.";
        String expected = "If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        Assertions.assertEquals((Object)"If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.", (Object)qpcodec.encode("If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy."));
        String decoded = qpcodec.decode("If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.");
        Assertions.assertEquals((Object)"If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.", (Object)qpcodec.encode(decoded));
    }

    @Test
    public void testSkipNotEncodedCRLF() throws Exception {
        String qpdata = "CRLF in an\n encoded text should be=20=\r\n\rskipped in the\r decoding.";
        String expected = "CRLF in an encoded text should be skipped in the decoding.";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        Assertions.assertEquals((Object)"CRLF in an encoded text should be skipped in the decoding.", (Object)qpcodec.decode("CRLF in an\n encoded text should be=20=\r\n\rskipped in the\r decoding."));
        String encoded = qpcodec.encode("CRLF in an encoded text should be skipped in the decoding.");
        Assertions.assertEquals((Object)"CRLF in an encoded text should be skipped in the decoding.", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testTrailingSpecial() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        String plain = "This is a example of a quoted-printable text file. This might contain sp=cial chars.";
        String expected = "This is a example of a quoted-printable text file. This might contain sp=3D=\r\ncial chars.";
        Assertions.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. This might contain ta\tbs as well.";
        expected = "This is a example of a quoted-printable text file. This might contain ta=09=\r\nbs as well.";
        Assertions.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
    }

    @Test
    public void testUltimateSoftBreak() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        String plain = "This is a example of a quoted-printable text file. There is no end to it\t";
        String expected = "This is a example of a quoted-printable text file. There is no end to i=\r\nt=09";
        Assertions.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. There is no end to it ";
        expected = "This is a example of a quoted-printable text file. There is no end to i=\r\nt=20";
        Assertions.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. There is no end to   ";
        expected = "This is a example of a quoted-printable text file. There is no end to=20=\r\n =20";
        Assertions.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. There is no end to=  ";
        expected = "This is a example of a quoted-printable text file. There is no end to=3D=\r\n =20";
        Assertions.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
    }

    @Test
    public void testFinalBytes() throws Exception {
        String plain = "This is a example of a quoted=printable text file. There is no tt";
        String expected = "This is a example of a quoted=3Dprintable text file. There is no tt";
        Assertions.assertEquals((Object)"This is a example of a quoted=3Dprintable text file. There is no tt", (Object)new QuotedPrintableCodec(true).encode("This is a example of a quoted=printable text file. There is no tt"));
    }
}

