/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.stream.Stream;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PhoneticEngineTest {
    private static final Integer TEN = 10;

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Renault", "rinD|rinDlt|rina|rinalt|rino|rinolt|rinu|rinult", NameType.GENERIC, RuleType.APPROX, Boolean.TRUE, TEN}), Arguments.of((Object[])new Object[]{"Renault", "rYnDlt|rYnalt|rYnult|rinDlt|rinalt|rinolt|rinult", NameType.ASHKENAZI, RuleType.APPROX, Boolean.TRUE, TEN}), Arguments.of((Object[])new Object[]{"Renault", "rinDlt", NameType.ASHKENAZI, RuleType.APPROX, Boolean.TRUE, 1}), Arguments.of((Object[])new Object[]{"Renault", "rinDlt", NameType.SEPHARDIC, RuleType.APPROX, Boolean.TRUE, TEN}), Arguments.of((Object[])new Object[]{"SntJohn-Smith", "sntjonsmit", NameType.GENERIC, RuleType.EXACT, Boolean.TRUE, TEN}), Arguments.of((Object[])new Object[]{"d'ortley", "(ortlaj|ortlej)-(dortlaj|dortlej)", NameType.GENERIC, RuleType.EXACT, Boolean.TRUE, TEN}), Arguments.of((Object[])new Object[]{"van helsing", "(elSink|elsink|helSink|helsink|helzink|xelsink)-(banhelsink|fanhelsink|fanhelzink|vanhelsink|vanhelzink|vanjelsink)", NameType.GENERIC, RuleType.EXACT, Boolean.FALSE, TEN}), Arguments.of((Object[])new Object[]{"Judenburg", "iudnbYrk|iudnbirk|iudnburk|xudnbirk|xudnburk|zudnbirk|zudnburk", NameType.GENERIC, RuleType.APPROX, Boolean.TRUE, TEN}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testEncode(String name, String phoneticExpected, NameType nameType, RuleType ruleType, boolean concat, int maxPhonemes) {
        PhoneticEngine engine = new PhoneticEngine(nameType, ruleType, concat, maxPhonemes);
        String phoneticActual = engine.encode(name);
        Assertions.assertEquals((Object)phoneticExpected, (Object)phoneticActual, (String)"phoneme incorrect");
        if (concat) {
            String[] split = phoneticActual.split("\\|");
            Assertions.assertTrue((split.length <= maxPhonemes ? 1 : 0) != 0);
        } else {
            String[] words;
            for (String word : words = phoneticActual.split("-")) {
                String[] split = word.split("\\|");
                Assertions.assertTrue((split.length <= maxPhonemes ? 1 : 0) != 0);
            }
        }
    }
}

