/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base32Test {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final String[][] BASE32_TEST_CASES = new String[][]{{"", ""}, {"f", "MY======"}, {"fo", "MZXQ===="}, {"foo", "MZXW6==="}, {"foob", "MZXW6YQ="}, {"fooba", "MZXW6YTB"}, {"foobar", "MZXW6YTBOI======"}};
    static final String[] BASE32_IMPOSSIBLE_CASES = new String[]{"MC======", "MZXE====", "MZXWB===", "MZXW6YB=", "MZXW6YTBOC======", "AB======"};
    private static final String[] BASE32_IMPOSSIBLE_CASES_CHUNKED = new String[]{"M2======\r\n", "MZX0====\r\n", "MZXW0===\r\n", "MZXW6Y2=\r\n", "MZXW6YTBO2======\r\n"};
    private static final String[] BASE32HEX_IMPOSSIBLE_CASES = new String[]{"C2======", "CPN4====", "CPNM1===", "CPNMUO1=", "CPNMUOJ1E2======"};
    private static final byte[] ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final Object[][] BASE32_BINARY_TEST_CASES;
    private static final String[][] BASE32HEX_TEST_CASES;
    private static final String[][] BASE32_TEST_CASES_CHUNKED;
    private static final String[][] BASE32_PAD_TEST_CASES;

    @Test
    public void testBase32AtBufferStart() {
        this.testBase32InBuffer(0, 100);
    }

    @Test
    public void testBase32AtBufferEnd() {
        this.testBase32InBuffer(100, 0);
    }

    @Test
    public void testBase32AtBufferMiddle() {
        this.testBase32InBuffer(100, 100);
    }

    private void testBase32InBuffer(int startPasSize, int endPadSize) {
        Base32 codec = new Base32();
        for (String[] element : BASE32_TEST_CASES) {
            byte[] bytes = element[0].getBytes(CHARSET_UTF8);
            byte[] buffer = ArrayUtils.addAll((byte[])bytes, (byte[])new byte[endPadSize]);
            buffer = ArrayUtils.addAll((byte[])new byte[startPasSize], (byte[])buffer);
            Assertions.assertEquals((Object)element[1], (Object)StringUtils.newStringUtf8((byte[])codec.encode(buffer, startPasSize, bytes.length)));
        }
    }

    @Test
    public void testBase32Chunked() throws Exception {
        Base32 codec = new Base32(20);
        for (String[] element : BASE32_TEST_CASES_CHUNKED) {
            Assertions.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testBase32HexSamples() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assertions.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testBase32HexSamplesReverse() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assertions.assertEquals((Object)element[0], (Object)new String(codec.decode(element[1]), CHARSET_UTF8));
        }
    }

    @Test
    public void testBase32HexSamplesReverseLowercase() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assertions.assertEquals((Object)element[0], (Object)new String(codec.decode(element[1].toLowerCase()), CHARSET_UTF8));
        }
    }

    @Test
    public void testBase32Samples() throws Exception {
        Base32 codec = new Base32();
        for (String[] element : BASE32_TEST_CASES) {
            Assertions.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testBase32BinarySamples() throws Exception {
        Base32 codec = new Base32();
        for (Object[] element : BASE32_BINARY_TEST_CASES) {
            String expected = element.length > 2 ? (String)element[2] : (String)element[1];
            Assertions.assertEquals((Object)expected.toUpperCase(), (Object)codec.encodeAsString((byte[])element[0]));
        }
    }

    @Test
    public void testBase32BinarySamplesReverse() throws Exception {
        Base32 codec = new Base32();
        for (Object[] element : BASE32_BINARY_TEST_CASES) {
            Assertions.assertArrayEquals((byte[])((byte[])element[0]), (byte[])codec.decode((String)element[1]));
        }
    }

    @Test
    public void testBase32SamplesNonDefaultPadding() throws Exception {
        Base32 codec = new Base32(37);
        for (String[] element : BASE32_PAD_TEST_CASES) {
            Assertions.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testCodec200() {
        Base32 codec = new Base32(true, 87);
        Assertions.assertNotNull((Object)codec);
    }

    @Test
    public void testConstructors() {
        Base32 base32 = new Base32();
        base32 = new Base32(-1);
        base32 = new Base32(-1, new byte[0]);
        base32 = new Base32(32, new byte[0]);
        base32 = new Base32(32, new byte[0], false);
        base32 = new Base32(-1, new byte[]{65});
        base32 = new Base32(32, new byte[]{36});
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Base32(32, null), (String)"null line separator");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Base32(32, new byte[]{65}), (String)"'A' as a line separator");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Base32(32, new byte[]{61}), (String)"'=' as a line separator");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Base32(32, new byte[]{65, 36}), (String)"'A$' as a line separator");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Base32(32, new byte[]{10}, false, 65), (String)"'A' as padding");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Base32(32, new byte[]{10}, false, 32), (String)"' ' as padding");
        base32 = new Base32(32, new byte[]{32, 36, 10, 13, 9});
        Assertions.assertNotNull((Object)base32);
    }

    @Test
    public void testEmptyBase32() {
        byte[] empty = new byte[]{};
        byte[] result = new Base32().encode(empty);
        Assertions.assertEquals((int)0, (int)result.length, (String)"empty Base32 encode");
        Assertions.assertNull((Object)new Base32().encode(null), (String)"empty Base32 encode");
        result = new Base32().encode(empty, 0, 1);
        Assertions.assertEquals((int)0, (int)result.length, (String)"empty Base32 encode with offset");
        Assertions.assertNull((Object)new Base32().encode(null), (String)"empty Base32 encode with offset");
        empty = new byte[]{};
        result = new Base32().decode(empty);
        Assertions.assertEquals((int)0, (int)result.length, (String)"empty Base32 decode");
        Assertions.assertNull((Object)new Base32().decode((byte[])null), (String)"empty Base32 encode");
    }

    @Test
    public void testIsInAlphabet() {
        int c;
        Base32 b32 = new Base32(true);
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)0));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)1));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)-1));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)-15));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)-32));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)127));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)-128));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)-1));
        b32 = new Base32(false);
        for (c = 50; c <= 55; c = (int)((char)(c + 1))) {
            Assertions.assertTrue((boolean)b32.isInAlphabet((byte)c));
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Assertions.assertTrue((boolean)b32.isInAlphabet((byte)c));
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Assertions.assertTrue((boolean)b32.isInAlphabet((byte)c));
        }
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)49));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)56));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)64));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)91));
        b32 = new Base32(true);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Assertions.assertTrue((boolean)b32.isInAlphabet((byte)c));
        }
        for (c = 65; c <= 86; c = (int)((char)(c + 1))) {
            Assertions.assertTrue((boolean)b32.isInAlphabet((byte)c));
        }
        for (c = 97; c <= 118; c = (int)((char)(c + 1))) {
            Assertions.assertTrue((boolean)b32.isInAlphabet((byte)c));
        }
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)47));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)58));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)64));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)87));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)96));
        Assertions.assertFalse((boolean)b32.isInAlphabet((byte)119));
    }

    @Test
    public void testRandomBytes() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32();
            byte[][] b = BaseNTestData.randomData((BaseNCodec)codec, i);
            Assertions.assertEquals((long)b[1].length, (long)codec.getEncodedLength(b[0]), (String)(i + " " + codec.lineLength));
        }
    }

    @Test
    public void testRandomBytesChunked() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32(10);
            byte[][] b = BaseNTestData.randomData((BaseNCodec)codec, i);
            Assertions.assertEquals((long)b[1].length, (long)codec.getEncodedLength(b[0]), (String)(i + " " + codec.lineLength));
        }
    }

    @Test
    public void testRandomBytesHex() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32(true);
            byte[][] b = BaseNTestData.randomData((BaseNCodec)codec, i);
            Assertions.assertEquals((long)b[1].length, (long)codec.getEncodedLength(b[0]), (String)(i + " " + codec.lineLength));
        }
    }

    @Test
    public void testSingleCharEncoding() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32();
            BaseNCodec.Context context = new BaseNCodec.Context();
            byte[] unencoded = new byte[i];
            byte[] allInOne = codec.encode(unencoded);
            codec = new Base32();
            for (int j = 0; j < unencoded.length; ++j) {
                codec.encode(unencoded, j, 1, context);
            }
            codec.encode(unencoded, 0, -1, context);
            byte[] singly = new byte[allInOne.length];
            codec.readResults(singly, 0, 100, context);
            if (Arrays.equals(allInOne, singly)) continue;
            Assertions.fail();
        }
    }

    @Test
    public void testBase32ImpossibleSamples() {
        this.testImpossibleCases(new Base32(0, null, false, 61, CodecPolicy.STRICT), BASE32_IMPOSSIBLE_CASES);
    }

    @Test
    public void testBase32ImpossibleChunked() {
        this.testImpossibleCases(new Base32(20, BaseNCodec.CHUNK_SEPARATOR, false, 61, CodecPolicy.STRICT), BASE32_IMPOSSIBLE_CASES_CHUNKED);
    }

    @Test
    public void testBase32HexImpossibleSamples() {
        this.testImpossibleCases(new Base32(0, null, true, 61, CodecPolicy.STRICT), BASE32HEX_IMPOSSIBLE_CASES);
    }

    private void testImpossibleCases(Base32 codec, String[] impossible_cases) {
        for (String impossible : impossible_cases) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> codec.decode(impossible));
        }
    }

    @Test
    public void testBase32DecodingOfTrailing5Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(5);
    }

    @Test
    public void testBase32DecodingOfTrailing10Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(10);
    }

    @Test
    public void testBase32DecodingOfTrailing15Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(15);
    }

    @Test
    public void testBase32DecodingOfTrailing20Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(20);
    }

    @Test
    public void testBase32DecodingOfTrailing25Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(25);
    }

    @Test
    public void testBase32DecodingOfTrailing30Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(30);
    }

    @Test
    public void testBase32DecodingOfTrailing35Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(35);
    }

    private static void assertBase32DecodingOfTrailingBits(int nbits) {
        Base32 codec = new Base32(0, null, false, 61, CodecPolicy.STRICT);
        Assertions.assertTrue((boolean)codec.isStrictDecoding());
        Assertions.assertEquals((Object)CodecPolicy.STRICT, (Object)codec.getCodecPolicy());
        Base32 defaultCodec = new Base32();
        Assertions.assertFalse((boolean)defaultCodec.isStrictDecoding());
        Assertions.assertEquals((Object)CodecPolicy.LENIENT, (Object)defaultCodec.getCodecPolicy());
        int length = nbits / 5;
        byte[] encoded = new byte[8];
        Arrays.fill(encoded, 0, length, ENCODE_TABLE[0]);
        Arrays.fill(encoded, length, encoded.length, (byte)61);
        int discard = nbits % 8;
        int emptyBitsMask = (1 << discard) - 1;
        boolean invalid = length == 1 || length == 3 || length == 6;
        int last = length - 1;
        for (int i = 0; i < 32; ++i) {
            byte[] decoded;
            encoded[last] = ENCODE_TABLE[i];
            if (invalid || (i & emptyBitsMask) != 0) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> codec.decode(encoded), (String)"Final base-32 digit should not be allowed");
                decoded = defaultCodec.decode(encoded);
                Assertions.assertFalse((boolean)Arrays.equals(encoded, defaultCodec.encode(decoded)));
                continue;
            }
            decoded = codec.decode(encoded);
            int bitsEncoded = i >> discard;
            Assertions.assertEquals((int)bitsEncoded, (int)decoded[decoded.length - 1], (String)"Invalid decoding of last character");
            Assertions.assertArrayEquals((byte[])encoded, (byte[])codec.encode(decoded));
        }
    }

    static {
        Hex hex = new Hex();
        try {
            BASE32_BINARY_TEST_CASES = new Object[][]{{hex.decode((Object)"623a01735836e9a126e12fbf95e013ee6892997c"), "MI5AC42YG3U2CJXBF67ZLYAT5ZUJFGL4"}, {hex.decode((Object)"623a01735836e9a126e12fbf95e013ee6892997c"), "mi5ac42yg3u2cjxbf67zlyat5zujfgl4"}, {hex.decode((Object)"739ce42108"), "OOOOIIII"}};
        }
        catch (DecoderException de) {
            throw new Error(":(", de);
        }
        BASE32HEX_TEST_CASES = new String[][]{{"", ""}, {"f", "CO======"}, {"fo", "CPNG===="}, {"foo", "CPNMU==="}, {"foob", "CPNMUOG="}, {"fooba", "CPNMUOJ1"}, {"foobar", "CPNMUOJ1E8======"}};
        BASE32_TEST_CASES_CHUNKED = new String[][]{{"", ""}, {"f", "MY======\r\n"}, {"fo", "MZXQ====\r\n"}, {"foo", "MZXW6===\r\n"}, {"foob", "MZXW6YQ=\r\n"}, {"fooba", "MZXW6YTB\r\n"}, {"foobar", "MZXW6YTBOI======\r\n"}};
        BASE32_PAD_TEST_CASES = new String[][]{{"", ""}, {"f", "MY%%%%%%"}, {"fo", "MZXQ%%%%"}, {"foo", "MZXW6%%%"}, {"foob", "MZXW6YQ%"}, {"fooba", "MZXW6YTB"}, {"foobar", "MZXW6YTBOI%%%%%%"}};
    }
}

