/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PhoneticEngineTest {
    private static final Integer TEN = 10;
    private final boolean concat;
    private final String name;
    private final NameType nameType;
    private final String phoneticExpected;
    private final RuleType ruleType;
    private final int maxPhonemes;

    @Parameterized.Parameters(name="{0}-{1}-{2}-{3}")
    public static List<Object[]> data() {
        return Arrays.asList({"Renault", "rinD|rinDlt|rina|rinalt|rino|rinolt|rinu|rinult", NameType.GENERIC, RuleType.APPROX, Boolean.TRUE, TEN}, {"Renault", "rYnDlt|rYnalt|rYnult|rinDlt|rinalt|rinolt|rinult", NameType.ASHKENAZI, RuleType.APPROX, Boolean.TRUE, TEN}, {"Renault", "rinDlt", NameType.ASHKENAZI, RuleType.APPROX, Boolean.TRUE, 1}, {"Renault", "rinDlt", NameType.SEPHARDIC, RuleType.APPROX, Boolean.TRUE, TEN}, {"SntJohn-Smith", "sntjonsmit", NameType.GENERIC, RuleType.EXACT, Boolean.TRUE, TEN}, {"d'ortley", "(ortlaj|ortlej)-(dortlaj|dortlej)", NameType.GENERIC, RuleType.EXACT, Boolean.TRUE, TEN}, {"van helsing", "(elSink|elsink|helSink|helsink|helzink|xelsink)-(banhelsink|fanhelsink|fanhelzink|vanhelsink|vanhelzink|vanjelsink)", NameType.GENERIC, RuleType.EXACT, Boolean.FALSE, TEN}, {"Judenburg", "iudnbYrk|iudnbirk|iudnburk|xudnbirk|xudnburk|zudnbirk|zudnburk", NameType.GENERIC, RuleType.APPROX, Boolean.TRUE, TEN});
    }

    public PhoneticEngineTest(String name, String phoneticExpected, NameType nameType, RuleType ruleType, boolean concat, int maxPhonemes) {
        this.name = name;
        this.phoneticExpected = phoneticExpected;
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = concat;
        this.maxPhonemes = maxPhonemes;
    }

    @Test(timeout=10000L)
    public void testEncode() {
        PhoneticEngine engine = new PhoneticEngine(this.nameType, this.ruleType, this.concat, this.maxPhonemes);
        String phoneticActual = engine.encode(this.name);
        Assert.assertEquals((String)"phoneme incorrect", (Object)this.phoneticExpected, (Object)phoneticActual);
        if (this.concat) {
            String[] split = phoneticActual.split("\\|");
            Assert.assertTrue((split.length <= this.maxPhonemes ? 1 : 0) != 0);
        } else {
            String[] words;
            for (String word : words = phoneticActual.split("-")) {
                String[] split = word.split("\\|");
                Assert.assertTrue((split.length <= this.maxPhonemes ? 1 : 0) != 0);
            }
        }
    }
}

