/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base16;
import org.apache.commons.codec.binary.Base16OutputStream;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base16OutputStreamTest {
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testBase16EmptyOutputStream() throws IOException {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded);
        this.testByChunk(emptyEncoded, emptyDecoded);
    }

    @Test
    public void testBase16OutputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"48656C6C6F20576F726C64");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String)"41");
        decoded = new byte[]{65};
        this.testByChunk(encoded, decoded);
        Base16 codec = new Base16(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, true);
        }
    }

    @Test
    public void testBase16OutputStreamByteByByte() throws IOException {
        byte[] encoded = StringUtils.getBytesUtf8((String)"48656C6C6F20576F726C64");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded);
        encoded = StringUtils.getBytesUtf8((String)"41");
        decoded = new byte[]{65};
        this.testByteByByte(encoded, decoded);
        Base16 codec = new Base16(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, true);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded) throws IOException {
        this.testByChunk(encoded, decoded, false);
    }

    private void testByChunk(byte[] encoded, byte[] decoded, boolean lowerCase) throws IOException {
        byte[] output2;
        Throwable throwable;
        Base16OutputStream out;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            out = new Base16OutputStream((OutputStream)byteOut, true, lowerCase);
            throwable = null;
            try {
                out.write(decoded);
                output2 = byteOut.toByteArray();
                Assert.assertArrayEquals((String)"Streaming chunked base16 encode", (byte[])encoded, (byte[])output2);
            }
            catch (Throwable output2) {
                throwable = output2;
                throw output2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable output2) {
                            throwable.addSuppressed(output2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        byteOut = new ByteArrayOutputStream();
        var5_5 = null;
        try {
            out = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            throwable = null;
            try {
                out.write(encoded);
                output2 = byteOut.toByteArray();
                Assert.assertArrayEquals((String)"Streaming chunked base16 decode", (byte[])decoded, (byte[])output2);
            }
            catch (Throwable output3) {
                throwable = output3;
                throw output3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable output3) {
                            throwable.addSuppressed(output3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Throwable out2) {
            var5_5 = out2;
            throw out2;
        }
        finally {
            if (byteOut != null) {
                if (var5_5 != null) {
                    try {
                        byteOut.close();
                    }
                    catch (Throwable out2) {
                        var5_5.addSuppressed(out2);
                    }
                } else {
                    byteOut.close();
                }
            }
        }
        byteOut = new ByteArrayOutputStream();
        var5_5 = null;
        try {
            Base16OutputStream decoderOut = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            Base16OutputStream encoderOut = new Base16OutputStream((OutputStream)decoderOut, true, lowerCase);
            encoderOut.write(decoded);
            output2 = byteOut.toByteArray();
            Assert.assertArrayEquals((String)"Streaming chunked base16 wrap-wrap!", (byte[])decoded, (byte[])output2);
        }
        catch (Throwable throwable2) {
            var5_5 = throwable2;
            throw throwable2;
        }
        finally {
            if (byteOut != null) {
                if (var5_5 != null) {
                    try {
                        byteOut.close();
                    }
                    catch (Throwable throwable3) {
                        var5_5.addSuppressed(throwable3);
                    }
                } else {
                    byteOut.close();
                }
            }
        }
    }

    private void testByteByByte(byte[] encoded, byte[] decoded) throws IOException {
        this.testByteByByte(encoded, decoded, false);
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, boolean lowerCase) throws IOException {
        byte[] output2;
        Throwable throwable;
        Base16OutputStream out;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            out = new Base16OutputStream((OutputStream)byteOut, true, lowerCase);
            throwable = null;
            try {
                for (byte element : decoded) {
                    out.write(element);
                }
                output2 = byteOut.toByteArray();
                Assert.assertArrayEquals((String)"Streaming byte-by-byte base16 encode", (byte[])encoded, (byte[])output2);
            }
            catch (Throwable output2) {
                throwable = output2;
                throw output2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable output2) {
                            throwable.addSuppressed(output2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        byteOut = new ByteArrayOutputStream();
        var5_5 = null;
        try {
            out = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            throwable = null;
            try {
                for (byte element : encoded) {
                    out.write(element);
                }
                output2 = byteOut.toByteArray();
                Assert.assertArrayEquals((String)"Streaming byte-by-byte base16 decode", (byte[])decoded, (byte[])output2);
            }
            catch (Throwable output3) {
                throwable = output3;
                throw output3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable output3) {
                            throwable.addSuppressed(output3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Throwable out2) {
            var5_5 = out2;
            throw out2;
        }
        finally {
            if (byteOut != null) {
                if (var5_5 != null) {
                    try {
                        byteOut.close();
                    }
                    catch (Throwable out2) {
                        var5_5.addSuppressed(out2);
                    }
                } else {
                    byteOut.close();
                }
            }
        }
        byteOut = new ByteArrayOutputStream();
        var5_5 = null;
        try {
            out = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
            throwable = null;
            try {
                for (byte element : encoded) {
                    out.write(element);
                    out.flush();
                }
                output2 = byteOut.toByteArray();
                Assert.assertArrayEquals((String)"Streaming byte-by-byte flush() base16 decode", (byte[])decoded, (byte[])output2);
            }
            catch (Throwable output4) {
                throwable = output4;
                throw output4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable output4) {
                            throwable.addSuppressed(output4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Throwable out3) {
            var5_5 = out3;
            throw out3;
        }
        finally {
            if (byteOut != null) {
                if (var5_5 != null) {
                    try {
                        byteOut.close();
                    }
                    catch (Throwable out3) {
                        var5_5.addSuppressed(out3);
                    }
                } else {
                    byteOut.close();
                }
            }
        }
        byteOut = new ByteArrayOutputStream();
        var5_5 = null;
        try {
            throwable = null;
            try (Base16OutputStream decoderOut = new Base16OutputStream((OutputStream)byteOut, false, lowerCase);
                 Base16OutputStream encoderOut = new Base16OutputStream((OutputStream)decoderOut, true, lowerCase);){
                for (byte element : decoded) {
                    encoderOut.write(element);
                }
                byte[] output5 = byteOut.toByteArray();
                Assert.assertArrayEquals((String)"Streaming byte-by-byte base16 wrap-wrap!", (byte[])decoded, (byte[])output5);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var5_5 = throwable3;
            throw throwable3;
        }
        finally {
            if (byteOut != null) {
                if (var5_5 != null) {
                    try {
                        byteOut.close();
                    }
                    catch (Throwable throwable4) {
                        var5_5.addSuppressed(throwable4);
                    }
                } else {
                    byteOut.close();
                }
            }
        }
    }

    @Test
    public void testWriteOutOfBounds() throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (Base16OutputStream out = new Base16OutputStream((OutputStream)bout);){
            try {
                out.write(buf, -1, 1);
                Assert.fail((String)"Expected Base16OutputStream.write(buf, -1, 1) to throw a IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                out.write(buf, 1, -1);
                Assert.fail((String)"Expected Base16OutputStream.write(buf, 1, -1) to throw a IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                out.write(buf, buf.length + 1, 0);
                Assert.fail((String)"Expected Base16OutputStream.write(buf, buf.length + 1, 0) to throw a IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                out.write(buf, buf.length - 1, 2);
                Assert.fail((String)"Expected Base16OutputStream.write(buf, buf.length - 1, 2) to throw a IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testWriteToNullCoverage() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (Base16OutputStream out = new Base16OutputStream((OutputStream)bout);){
            out.write(null, 0, 0);
            Assert.fail((String)"Expcted Base16OutputStream.write(null) to throw a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

