/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LanguageGuessingTest {
    private final Lang lang = Lang.instance((NameType)NameType.GENERIC);
    private final String language;
    private final String name;

    @Parameterized.Parameters(name="{0}-{1}-{2}")
    public static List<Object[]> data() {
        return Arrays.asList({"Renault", "french"}, {"Mickiewicz", "polish"}, {"Thompson", "english"}, {"Nu\u00f1ez", "spanish"}, {"Carvalho", "portuguese"}, {"\u010capek", "czech"}, {"Sjneijder", "dutch"}, {"Klausewitz", "german"}, {"K\u00fc\u00e7\u00fck", "turkish"}, {"Giacometti", "italian"}, {"Nagy", "hungarian"}, {"Ceau\u015fescu", "romanian"}, {"Angelopoulos", "greeklatin"}, {"\u0391\u03b3\u03b3\u03b5\u03bb\u03cc\u03c0\u03bf\u03c5\u03bb\u03bf\u03c2", "greek"}, {"\u041f\u0443\u0448\u043a\u0438\u043d", "cyrillic"}, {"\u05db\u05d4\u05df", "hebrew"}, {"\u00e1cz", "any"}, {"\u00e1tz", "any"});
    }

    public LanguageGuessingTest(String name, String language) {
        this.name = name;
        this.language = language;
    }

    @Test
    public void testLanguageGuessing() {
        Languages.LanguageSet guesses = this.lang.guessLanguages(this.name);
        Assert.assertTrue((String)("language predicted for name '" + this.name + "' is wrong: " + guesses + " should contain '" + this.language + "'"), (boolean)guesses.contains(this.language));
    }
}

