/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.Nysiis;
import org.junit.Assert;
import org.junit.Test;

public class NysiisTest
extends StringEncoderAbstractTest<Nysiis> {
    private final Nysiis fullNysiis = new Nysiis(false);

    private void assertEncodings(String[] ... testValues) throws EncoderException {
        for (String[] arr : testValues) {
            Assert.assertEquals((String)("Problem with " + arr[0]), (Object)arr[1], (Object)this.fullNysiis.encode(arr[0]));
        }
    }

    @Override
    protected Nysiis createStringEncoder() {
        return new Nysiis();
    }

    private void encodeAll(String[] strings, String expectedEncoding) {
        for (String string : strings) {
            Assert.assertEquals((String)("Problem with " + string), (Object)expectedEncoding, (Object)((Nysiis)this.getStringEncoder()).encode(string));
        }
    }

    @Test
    public void testBran() {
        this.encodeAll(new String[]{"Brian", "Brown", "Brun"}, "BRAN");
    }

    @Test
    public void testCap() {
        this.encodeAll(new String[]{"Capp", "Cope", "Copp", "Kipp"}, "CAP");
    }

    @Test
    public void testDad() {
        this.encodeAll(new String[]{"Dent"}, "DAD");
    }

    @Test
    public void testDan() {
        this.encodeAll(new String[]{"Dane", "Dean", "Dionne"}, "DAN");
    }

    @Test
    public void testDropBy() throws EncoderException {
        this.assertEncodings({"MACINTOSH", "MCANT"}, {"KNUTH", "NAT"}, {"KOEHN", "CAN"}, {"PHILLIPSON", "FALAPSAN"}, {"PFEISTER", "FASTAR"}, {"SCHOENHOEFT", "SANAFT"}, {"MCKEE", "MCY"}, {"MACKIE", "MCY"}, {"HEITSCHMIDT", "HATSNAD"}, {"BART", "BAD"}, {"HURD", "HAD"}, {"HUNT", "HAD"}, {"WESTERLUND", "WASTARLAD"}, {"CASSTEVENS", "CASTAFAN"}, {"VASQUEZ", "VASG"}, {"FRAZIER", "FRASAR"}, {"BOWMAN", "BANAN"}, {"MCKNIGHT", "MCNAGT"}, {"RICKERT", "RACAD"}, {"DEUTSCH", "DAT"}, {"WESTPHAL", "WASTFAL"}, {"SHRIVER", "SRAVAR"}, {"KUHL", "CAL"}, {"RAWSON", "RASAN"}, {"JILES", "JAL"}, {"CARRAWAY", "CARY"}, {"YAMADA", "YANAD"});
    }

    @Test
    public void testFal() {
        this.encodeAll(new String[]{"Phil"}, "FAL");
    }

    @Test
    public void testOthers() throws EncoderException {
        this.assertEncodings({"O'Daniel", "ODANAL"}, {"O'Donnel", "ODANAL"}, {"Cory", "CARY"}, {"Corey", "CARY"}, {"Kory", "CARY"}, {"FUZZY", "FASY"});
    }

    @Test
    public void testRule1() throws EncoderException {
        this.assertEncodings({"MACX", "MCX"}, {"KNX", "NX"}, {"KX", "CX"}, {"PHX", "FX"}, {"PFX", "FX"}, {"SCHX", "SX"});
    }

    @Test
    public void testRule2() throws EncoderException {
        this.assertEncodings({"XEE", "XY"}, {"XIE", "XY"}, {"XDT", "XD"}, {"XRT", "XD"}, {"XRD", "XD"}, {"XNT", "XD"}, {"XND", "XD"});
    }

    @Test
    public void testRule4Dot1() throws EncoderException {
        this.assertEncodings({"XEV", "XAF"}, {"XAX", "XAX"}, {"XEX", "XAX"}, {"XIX", "XAX"}, {"XOX", "XAX"}, {"XUX", "XAX"});
    }

    @Test
    public void testRule4Dot2() throws EncoderException {
        this.assertEncodings({"XQ", "XG"}, {"XZ", "X"}, {"XM", "XN"});
    }

    @Test
    public void testRule5() throws EncoderException {
        this.assertEncodings({"XS", "X"}, {"XSS", "X"});
    }

    @Test
    public void testRule6() throws EncoderException {
        this.assertEncodings({"XAY", "XY"}, {"XAYS", "XY"});
    }

    @Test
    public void testRule7() throws EncoderException {
        this.assertEncodings({"XA", "X"}, {"XAS", "X"});
    }

    @Test
    public void testSnad() {
        this.encodeAll(new String[]{"Schmidt"}, "SNAD");
    }

    @Test
    public void testSnat() {
        this.encodeAll(new String[]{"Smith", "Schmit"}, "SNAT");
    }

    @Test
    public void testSpecialBranches() {
        this.encodeAll(new String[]{"Kobwick"}, "CABWAC");
        this.encodeAll(new String[]{"Kocher"}, "CACAR");
        this.encodeAll(new String[]{"Fesca"}, "FASC");
        this.encodeAll(new String[]{"Shom"}, "SAN");
        this.encodeAll(new String[]{"Ohlo"}, "OL");
        this.encodeAll(new String[]{"Uhu"}, "UH");
        this.encodeAll(new String[]{"Um"}, "UN");
    }

    @Test
    public void testTranan() {
        this.encodeAll(new String[]{"Trueman", "Truman"}, "TRANAN");
    }

    @Test
    public void testTrueVariant() {
        Nysiis encoder = new Nysiis(true);
        String encoded = encoder.encode("WESTERLUND");
        Assert.assertTrue((encoded.length() <= 6 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"WASTAR", (Object)encoded);
    }
}

