/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.Sha2Crypt;
import org.junit.Assert;
import org.junit.Test;

public class Sha256CryptTest {
    @Test
    public void testSha256CryptStrings() {
        Assert.assertEquals((Object)"$5$foo$Fq9CX624QIfnCAmlGiPKLlAasdacKCRxZztPoeo7o0B", (Object)Crypt.crypt((String)"", (String)"$5$foo"));
        Assert.assertEquals((Object)"$5$45678$LulJuUIJIn.1uU.KPV9x92umMYFopzVDD.o2ZqA1i2/", (Object)Crypt.crypt((String)"secret", (String)"$5$45678"));
        Assert.assertEquals((Object)"$5$45678$LulJuUIJIn.1uU.KPV9x92umMYFopzVDD.o2ZqA1i2/", (Object)Crypt.crypt((String)"secret", (String)"$5$45678$012"));
        Assert.assertEquals((Object)"$5$45678$LulJuUIJIn.1uU.KPV9x92umMYFopzVDD.o2ZqA1i2/", (Object)Crypt.crypt((String)"secret", (String)"$5$45678$012$456"));
        Assert.assertEquals((Object)"$5$1234567890123456$GUiFKBSTUAGvcK772ulTDPltkTOLtFvPOmp9o.9FNPB", (Object)Crypt.crypt((String)"secret", (String)"$5$1234567890123456"));
        Assert.assertEquals((Object)"$5$1234567890123456$GUiFKBSTUAGvcK772ulTDPltkTOLtFvPOmp9o.9FNPB", (Object)Crypt.crypt((String)"secret", (String)"$5$1234567890123456789"));
    }

    @Test
    public void testSha256CryptBytes() {
        Assert.assertEquals((Object)"$5$foo$Fq9CX624QIfnCAmlGiPKLlAasdacKCRxZztPoeo7o0B", (Object)Crypt.crypt((byte[])new byte[0], (String)"$5$foo"));
        Assert.assertEquals((Object)"$5$./$iH66LwY5sTDTdHeOxq5nvNDVAxuoCcyH/y6Ptte82P8", (Object)Crypt.crypt((String)"t\u00e4st", (String)"$5$./$"));
        Assert.assertEquals((Object)"$5$./$qx5gFfCzjuWUOvsDDy.5Nor3UULPIqLVBZhgGNS0c14", (Object)Crypt.crypt((byte[])"t\u00e4st".getBytes(Charsets.ISO_8859_1), (String)"$5$./$"));
    }

    @Test
    public void testSha2CryptRounds() {
        Assert.assertEquals((Object)"$5$rounds=1000$abcd$b8MCU4GEeZIekOy5ahQ8EWfT330hvYGVeDYkBxXBva.", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=50$abcd$"));
        Assert.assertEquals((Object)"$5$rounds=1001$abcd$SQsJZs7KXKdd2DtklI3TY3tkD7UYA99RD0FBLm4Sk48", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=1001$abcd$"));
        Assert.assertEquals((Object)"$5$rounds=9999$abcd$Rh/8ngVh9oyuS6lL3.fsq.9xbvXJsfyKWxSjO2mPIa7", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=9999$abcd"));
    }

    @Test
    public void testSha2CryptRoundsThreadLocalRandom() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Assert.assertEquals((Object)"$5$rounds=1000$abcd$b8MCU4GEeZIekOy5ahQ8EWfT330hvYGVeDYkBxXBva.", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=50$abcd$", (Random)random));
        Assert.assertEquals((Object)"$5$rounds=1001$abcd$SQsJZs7KXKdd2DtklI3TY3tkD7UYA99RD0FBLm4Sk48", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=1001$abcd$", (Random)random));
        Assert.assertEquals((Object)"$5$rounds=9999$abcd$Rh/8ngVh9oyuS6lL3.fsq.9xbvXJsfyKWxSjO2mPIa7", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=9999$abcd", (Random)random));
    }

    @Test
    public void testSha256CryptExplicitCall() {
        Assert.assertTrue((boolean)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes()).matches("^\\$5\\$[a-zA-Z0-9./]{0,16}\\$.{1,}$"));
        Assert.assertTrue((boolean)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(), null).matches("^\\$5\\$[a-zA-Z0-9./]{0,16}\\$.{1,}$"));
    }

    @Test(expected=NullPointerException.class)
    public void testSha256CryptNullData() {
        Sha2Crypt.sha256Crypt((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha256CryptWithEmptySalt() {
        Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(), (String)"");
    }

    @Test
    public void testSha256LargetThanBlocksize() {
        byte[] buffer = new byte[200];
        Arrays.fill(buffer, 0, 200, (byte)65);
        Assert.assertEquals((Object)"$5$abc$HbF3RRc15OwNKB/RZZ5F.1I6zsLcKXHQoSdB9Owx/Q8", (Object)Sha2Crypt.sha256Crypt((byte[])buffer, (String)"$5$abc"));
    }
}

