/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.digest.MurmurHash3;
import org.junit.Assert;
import org.junit.Test;

public class MurmurHash3Test {
    private static final String TEST = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?";

    @Test
    public void test32_String() {
        String origin = TEST;
        int result = MurmurHash3.hash32((String)TEST);
        Assert.assertEquals((long)-436507231L, (long)result);
    }

    @Test
    public void testHashCodeM3_64() {
        byte[] origin = TEST.getBytes();
        long hash = MurmurHash3.hash64((byte[])origin, (int)0, (int)origin.length);
        Assert.assertEquals((long)5785358552565094607L, (long)hash);
        byte[] originOffset = new byte[origin.length + 150];
        Arrays.fill(originOffset, (byte)123);
        System.arraycopy(origin, 0, originOffset, 150, origin.length);
        hash = MurmurHash3.hash64((byte[])originOffset, (int)150, (int)origin.length);
        Assert.assertEquals((long)5785358552565094607L, (long)hash);
    }

    @Test
    public void test64() {
        int seed = 123;
        int iters = 1000000;
        ByteBuffer SHORT_BUFFER = ByteBuffer.allocate(2);
        ByteBuffer INT_BUFFER = ByteBuffer.allocate(4);
        ByteBuffer LONG_BUFFER = ByteBuffer.allocate(8);
        Random rdm = new Random(123L);
        for (int i = 0; i < 1000000; ++i) {
            long ln = rdm.nextLong();
            int in = rdm.nextInt();
            short sn = (short)(rdm.nextInt(65533) - Short.MAX_VALUE);
            float fn = rdm.nextFloat();
            double dn = rdm.nextDouble();
            SHORT_BUFFER.putShort(0, sn);
            Assert.assertEquals((long)MurmurHash3.hash64((byte[])SHORT_BUFFER.array()), (long)MurmurHash3.hash64((short)sn));
            INT_BUFFER.putInt(0, in);
            Assert.assertEquals((long)MurmurHash3.hash64((byte[])INT_BUFFER.array()), (long)MurmurHash3.hash64((int)in));
            LONG_BUFFER.putLong(0, ln);
            Assert.assertEquals((long)MurmurHash3.hash64((byte[])LONG_BUFFER.array()), (long)MurmurHash3.hash64((long)ln));
            INT_BUFFER.putFloat(0, fn);
            Assert.assertEquals((long)MurmurHash3.hash64((byte[])INT_BUFFER.array()), (long)MurmurHash3.hash64((int)Float.floatToIntBits(fn)));
            LONG_BUFFER.putDouble(0, dn);
            Assert.assertEquals((long)MurmurHash3.hash64((byte[])LONG_BUFFER.array()), (long)MurmurHash3.hash64((long)Double.doubleToLongBits(dn)));
        }
    }

    @Test
    public void test128_Short() {
        ByteBuffer BUFFER = ByteBuffer.allocate(2);
        BUFFER.putShort(0, (short)2);
        long[] result = MurmurHash3.hash128((byte[])BUFFER.array());
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)8673501042631707204L, (long)result[0]);
        Assert.assertEquals((long)491907755572407714L, (long)result[1]);
    }

    @Test
    public void test128_Int() {
        ByteBuffer BUFFER = ByteBuffer.allocate(4);
        BUFFER.putInt(0, 3);
        long[] result = MurmurHash3.hash128((byte[])BUFFER.array());
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)2448828847287705405L, (long)result[0]);
        Assert.assertEquals((long)-4568642211270719983L, (long)result[1]);
    }

    @Test
    public void test128_Long() {
        ByteBuffer BUFFER = ByteBuffer.allocate(8);
        BUFFER.putLong(0, 8675309L);
        long[] result = MurmurHash3.hash128((byte[])BUFFER.array());
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)2339756411022791995L, (long)result[0]);
        Assert.assertEquals((long)8242951144762217305L, (long)result[1]);
    }

    @Test
    public void test128_Double() {
        ByteBuffer BUFFER = ByteBuffer.allocate(8);
        BUFFER.putDouble(0, 456.987);
        long[] result = MurmurHash3.hash128((byte[])BUFFER.array());
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)6877430437712399133L, (long)result[0]);
        Assert.assertEquals((long)-8576421050167250536L, (long)result[1]);
    }

    @Test
    public void test128_String() {
        String origin = TEST;
        long[] result = MurmurHash3.hash128((String)TEST);
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)6409160382500807310L, (long)result[0]);
        Assert.assertEquals((long)-7835827609130513921L, (long)result[1]);
    }

    @Test
    public void testIncremental() {
        int seed = 123;
        int arraySize = 1023;
        byte[] bytes = new byte[1023];
        new Random(123L).nextBytes(bytes);
        int expected = MurmurHash3.hash32((byte[])bytes, (int)1023);
        MurmurHash3.IncrementalHash32 same = new MurmurHash3.IncrementalHash32();
        MurmurHash3.IncrementalHash32 diff = new MurmurHash3.IncrementalHash32();
        for (int blockSize = 1; blockSize <= 1023; ++blockSize) {
            byte[] block = new byte[blockSize];
            same.start(104729);
            diff.start(104729);
            for (int offset = 0; offset < 1023; offset += blockSize) {
                int length = Math.min(1023 - offset, blockSize);
                same.add(bytes, offset, length);
                System.arraycopy(bytes, offset, block, 0, length);
                diff.add(block, 0, length);
            }
            Assert.assertEquals((String)("Block size " + blockSize), (long)expected, (long)same.end());
            Assert.assertEquals((String)("Block size " + blockSize), (long)expected, (long)diff.end());
        }
    }

    @Test
    public void testTwoLongOrdered() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        for (long i = 0L; i < 1000L; ++i) {
            for (long j = 0L; j < 1000L; ++j) {
                buffer.putLong(0, i);
                buffer.putLong(8, j);
                Assert.assertEquals((long)MurmurHash3.hash32((byte[])buffer.array()), (long)MurmurHash3.hash32((long)i, (long)j));
            }
        }
    }

    @Test
    public void testTwoLongRandom() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        Random random = new Random();
        for (long i = 0L; i < 1000L; ++i) {
            for (long j = 0L; j < 1000L; ++j) {
                long x = random.nextLong();
                long y = random.nextLong();
                buffer.putLong(0, x);
                buffer.putLong(8, y);
                Assert.assertEquals((long)MurmurHash3.hash32((byte[])buffer.array()), (long)MurmurHash3.hash32((long)x, (long)y));
            }
        }
    }

    @Test
    public void testSingleLongOrdered() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        for (long i = 0L; i < 1000L; ++i) {
            buffer.putLong(0, i);
            Assert.assertEquals((long)MurmurHash3.hash32((byte[])buffer.array()), (long)MurmurHash3.hash32((long)i));
        }
    }

    @Test
    public void testSingleLongRandom() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        Random random = new Random();
        for (long i = 0L; i < 1000L; ++i) {
            long x = random.nextLong();
            buffer.putLong(0, x);
            Assert.assertEquals((long)MurmurHash3.hash32((byte[])buffer.array()), (long)MurmurHash3.hash32((long)x));
        }
    }
}

