/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.binary.Base64TestData;
import org.apache.commons.codec.binary.Codec105ErrorInputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base64InputStreamTest {
    private static final String ENCODED_B64 = "AAAA////";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testCodec130() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (Base64OutputStream base64os = new Base64OutputStream((OutputStream)bos);){
            base64os.write(StringUtils.getBytesUtf8((String)STRING_FIXTURE));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        Base64InputStream ins = new Base64InputStream((InputStream)bis);
        ins.skip(1L);
        byte[] decodedBytes = Base64TestData.streamToBytes((InputStream)ins, new byte[64]);
        String str = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assert.assertEquals((Object)STRING_FIXTURE.substring(1), (Object)str);
    }

    @Test
    public void testCodec105() throws IOException {
        try (Base64InputStream in = new Base64InputStream((InputStream)new Codec105ErrorInputStream(), true, 0, null);){
            for (int i = 0; i < 5; ++i) {
                in.read();
            }
        }
    }

    @Test
    public void testCodec101() throws Exception {
        byte[] codec101 = StringUtils.getBytesUtf8((String)"124");
        ByteArrayInputStream bais = new ByteArrayInputStream(codec101);
        try (Base64InputStream in = new Base64InputStream((InputStream)bais);){
            byte[] result = new byte[8192];
            int c = in.read(result);
            Assert.assertTrue((String)("Codec101: First read successful [c=" + c + "]"), (c > 0 ? 1 : 0) != 0);
            c = in.read(result);
            Assert.assertTrue((String)("Codec101: Second read should report end-of-stream [c=" + c + "]"), (c < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInputStreamReader() throws Exception {
        byte[] codec101 = StringUtils.getBytesUtf8((String)"124");
        ByteArrayInputStream bais = new ByteArrayInputStream(codec101);
        Base64InputStream in = new Base64InputStream((InputStream)bais);
        InputStreamReader isr = new InputStreamReader((InputStream)in);
        try (BufferedReader br = new BufferedReader(isr);){
            String line = br.readLine();
            Assert.assertNotNull((String)"Codec101:  InputStreamReader works!", (Object)line);
        }
    }

    @Test
    public void testCodec98NPE() throws Exception {
        byte[] codec98 = StringUtils.getBytesUtf8((String)"YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXpBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWjAxMjM");
        ByteArrayInputStream data = new ByteArrayInputStream(codec98);
        Base64InputStream stream = new Base64InputStream((InputStream)data);
        byte[] decodedBytes = Base64TestData.streamToBytes((InputStream)stream, new byte[1024]);
        String decoded = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assert.assertEquals((String)"codec-98 NPE Base64InputStream", (Object)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123", (Object)decoded);
    }

    @Test
    public void testAvailable() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assert.assertEquals((long)1L, (long)b64stream.available());
            Assert.assertEquals((long)6L, (long)b64stream.skip(10L));
            Assert.assertEquals((long)0L, (long)b64stream.available());
            Assert.assertEquals((long)-1L, (long)b64stream.read());
            Assert.assertEquals((long)-1L, (long)b64stream.read());
            Assert.assertEquals((long)0L, (long)b64stream.available());
        }
    }

    @Test
    public void testBase64EmptyInputStreamMimeChuckSize() throws Exception {
        this.testBase64EmptyInputStream(76);
    }

    @Test
    public void testBase64EmptyInputStreamPemChuckSize() throws Exception {
        this.testBase64EmptyInputStream(64);
    }

    private void testBase64EmptyInputStream(int chuckSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chuckSize, CRLF);
        this.testByChunk(emptyEncoded, emptyDecoded, chuckSize, CRLF);
    }

    @Test
    public void testBase64InputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"SGVsbG8gV29ybGQ=\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA==\r\n");
        decoded = new byte[]{0};
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n");
        decoded = Base64TestData.DECODED;
        this.testByChunk(encoded, decoded, 64, LF);
        String singleLine = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n".replaceAll("\n", "");
        encoded = StringUtils.getBytesUtf8((String)singleLine);
        decoded = Base64TestData.DECODED;
        this.testByChunk(encoded, decoded, 0, LF);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base64TestData.randomData(i, false);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    public void testBase64InputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"SGVsbG8gV29ybGQ=\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA==\r\n");
        decoded = new byte[]{0};
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n");
        decoded = Base64TestData.DECODED;
        this.testByteByByte(encoded, decoded, 64, LF);
        String singleLine = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n".replaceAll("\n", "");
        encoded = StringUtils.getBytesUtf8((String)singleLine);
        decoded = Base64TestData.DECODED;
        this.testByteByByte(encoded, decoded, 0, LF);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base64TestData.randomData(i, false);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        Object in = new Base64InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);
        byte[] output = Base64TestData.streamToBytes((InputStream)in);
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base64 encode", (boolean)Arrays.equals(output, encoded));
        ((InputStream)in).close();
        in = new Base64InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = Base64TestData.streamToBytes((InputStream)in);
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base64 decode", (boolean)Arrays.equals(output, decoded));
        in = new ByteArrayInputStream(decoded);
        for (int i = 0; i < 10; ++i) {
            in = new Base64InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base64InputStream((InputStream)in, false);
        }
        output = Base64TestData.streamToBytes((InputStream)in);
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base64 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
        ((InputStream)in).close();
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        int i;
        Object in = new Base64InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);
        byte[] output = new byte[encoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base64 encode", (boolean)Arrays.equals(output, encoded));
        ((InputStream)in).close();
        in = new Base64InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base64 decode", (boolean)Arrays.equals(output, decoded));
        ((InputStream)in).close();
        in = new ByteArrayInputStream(decoded);
        for (i = 0; i < 10; ++i) {
            in = new Base64InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base64InputStream((InputStream)in, false);
        }
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base64 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
        ((InputStream)in).close();
    }

    @Test
    public void testMarkSupported() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assert.assertFalse((String)"Base64InputStream.markSupported() is false", (boolean)in.markSupported());
        }
    }

    @Test
    public void testRead0() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            bytesRead = in.read(buf, 0, 0);
            Assert.assertEquals((String)"Base64InputStream.read(buf, 0, 0) returns 0", (long)0L, (long)bytesRead);
        }
    }

    @Test
    public void testReadNull() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            in.read(null, 0, 0);
            Assert.fail((String)"Base64InputStream.read(null, 0, 0) to throw a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testReadOutOfBounds() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base64InputStream in = new Base64InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            try {
                in.read(buf, -1, 0);
                Assert.fail((String)"Expected Base64InputStream.read(buf, -1, 0) to throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                in.read(buf, 0, -1);
                Assert.fail((String)"Expected Base64InputStream.read(buf, 0, -1) to throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                in.read(buf, buf.length + 1, 0);
                Assert.fail((String)"Base64InputStream.read(buf, buf.length + 1, 0) throws IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                in.read(buf, buf.length - 1, 2);
                Assert.fail((String)"Base64InputStream.read(buf, buf.length - 1, 2) throws IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSkipBig() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assert.assertEquals((long)6L, (long)b64stream.skip(Integer.MAX_VALUE));
            Assert.assertEquals((long)-1L, (long)b64stream.read());
            Assert.assertEquals((long)-1L, (long)b64stream.read());
        }
    }

    @Test
    public void testSkipNone() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            byte[] actualBytes = new byte[6];
            Assert.assertEquals((long)0L, (long)b64stream.skip(0L));
            b64stream.read(actualBytes, 0, actualBytes.length);
            Assert.assertArrayEquals((byte[])actualBytes, (byte[])new byte[]{0, 0, 0, -1, -1, -1});
            Assert.assertEquals((long)-1L, (long)b64stream.read());
        }
    }

    @Test
    public void testSkipPastEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assert.assertEquals((long)6L, (long)b64stream.skip(10L));
            Assert.assertEquals((long)-1L, (long)b64stream.read());
            Assert.assertEquals((long)-1L, (long)b64stream.read());
        }
    }

    @Test
    public void testSkipToEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            Assert.assertEquals((long)6L, (long)b64stream.skip(6L));
            Assert.assertEquals((long)-1L, (long)b64stream.read());
            Assert.assertEquals((long)-1L, (long)b64stream.read());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSkipWrongArgument() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_B64));
        try (Base64InputStream b64stream = new Base64InputStream((InputStream)ins);){
            b64stream.skip(-10L);
        }
    }
}

