/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.HashSet;
import org.apache.commons.cli.AbstractParserTestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultParserTest
extends AbstractParserTestCase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.parser = new DefaultParser();
    }

    @Test
    public void testBuilder() {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).setAllowPartialMatching(false).setDeprecatedHandler(null).build();
        Assertions.assertEquals(DefaultParser.class, this.parser.getClass());
    }

    @Test
    public void testDeprecated() throws ParseException {
        HashSet handler = new HashSet();
        this.parser = DefaultParser.builder().setDeprecatedHandler(handler::add).build();
        Option opt1 = Option.builder().option("d1").deprecated().build();
        Option opt2 = Option.builder().option("d2").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("1.0").setDescription("Do this instead.").get()).build();
        Option opt3 = Option.builder().option("a").build();
        CommandLine cl = this.parser.parse(new Options().addOption(opt1).addOption(opt2).addOption(opt3), new String[]{"-d1", "-d2", "-a"});
        Assertions.assertTrue((boolean)cl.hasOption(opt1.getOpt()));
        Assertions.assertTrue((boolean)cl.hasOption(opt2.getOpt()));
        Assertions.assertTrue((boolean)cl.hasOption(opt3.getOpt()));
        Assertions.assertTrue((boolean)handler.contains(opt1));
        Assertions.assertTrue((boolean)handler.contains(opt2));
        Assertions.assertFalse((boolean)handler.contains(opt3));
    }

    @Test
    public void testLongOptionQuoteHandlingWithoutStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        String[] args = new String[]{"--bfile", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"\"quoted string\"", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile \"arg\" keeps quotes");
    }

    @Test
    public void testLongOptionQuoteHandlingWithStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).build();
        String[] args = new String[]{"--bfile", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile \"arg\" strips quotes");
    }

    @Override
    @Test
    public void testLongOptionWithEqualsQuoteHandling() throws Exception {
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"\"quoted string\"", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile=\"arg\" strips quotes");
    }

    @Test
    public void testLongOptionWithEqualsQuoteHandlingWithoutStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"\"quoted string\"", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile=\"arg\" keeps quotes");
    }

    @Test
    public void testLongOptionWithEqualsQuoteHandlingWithStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).build();
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm --bfile=\"arg\" strips quotes");
    }

    @Override
    @Test
    public void testShortOptionConcatenatedQuoteHandling() throws Exception {
        String[] args = new String[]{"-b\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"\"quoted string\"", (Object)cl.getOptionValue("b"), (String)"Confirm -b\"arg\" keeps quotes");
    }

    @Test
    public void testShortOptionQuoteHandlingWithoutStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        String[] args = new String[]{"-b", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"\"quoted string\"", (Object)cl.getOptionValue("b"), (String)"Confirm -b \"arg\" keeps quotes");
    }

    @Test
    public void testShortOptionQuoteHandlingWithStrip() throws Exception {
        this.parser = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).build();
        String[] args = new String[]{"-b", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"quoted string", (Object)cl.getOptionValue("b"), (String)"Confirm -b \"arg\" strips quotes");
    }
}

