/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.DeprecatedAttributes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeprecatedAttributesTest {
    @Test
    public void testBuilderNonDefaults() {
        DeprecatedAttributes value = DeprecatedAttributes.builder().setDescription("Use Bar instead!").setForRemoval(true).setSince("2.0").get();
        Assertions.assertEquals((Object)"Use Bar instead!", (Object)value.getDescription());
        Assertions.assertEquals((Object)"2.0", (Object)value.getSince());
        Assertions.assertEquals((Object)true, (Object)value.isForRemoval());
    }

    @Test
    public void testBuilderNonDefaultsToString() {
        Assertions.assertEquals((Object)"Deprecated for removal since 2.0: Use Bar instead!", (Object)DeprecatedAttributes.builder().setDescription("Use Bar instead!").setForRemoval(true).setSince("2.0").get().toString());
        Assertions.assertEquals((Object)"Deprecated for removal: Use Bar instead!", (Object)DeprecatedAttributes.builder().setDescription("Use Bar instead!").setForRemoval(true).get().toString());
        Assertions.assertEquals((Object)"Deprecated since 2.0: Use Bar instead!", (Object)DeprecatedAttributes.builder().setDescription("Use Bar instead!").setSince("2.0").get().toString());
        Assertions.assertEquals((Object)"Deprecated: Use Bar instead!", (Object)DeprecatedAttributes.builder().setDescription("Use Bar instead!").get().toString());
    }

    @Test
    public void testDefaultBuilder() {
        DeprecatedAttributes defaultValue = DeprecatedAttributes.builder().get();
        Assertions.assertEquals((Object)DeprecatedAttributes.DEFAULT.getDescription(), (Object)defaultValue.getDescription());
        Assertions.assertEquals((Object)DeprecatedAttributes.DEFAULT.getSince(), (Object)defaultValue.getSince());
        Assertions.assertEquals((Object)DeprecatedAttributes.DEFAULT.isForRemoval(), (Object)defaultValue.isForRemoval());
    }

    @Test
    public void testDefaultToString() {
        Assertions.assertEquals((Object)"Deprecated", (Object)DeprecatedAttributes.DEFAULT.toString());
    }
}

