/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Test;

public class OptionsTest {
    @Test
    public void testSimple() {
        Options opts = new Options();
        opts.addOption("a", false, "toggle -a");
        opts.addOption("b", true, "toggle -b");
        Assert.assertTrue((boolean)opts.hasOption("a"));
        Assert.assertTrue((boolean)opts.hasOption("b"));
    }

    @Test
    public void testDuplicateSimple() {
        Options opts = new Options();
        opts.addOption("a", false, "toggle -a");
        opts.addOption("a", true, "toggle -a*");
        Assert.assertEquals((String)"last one in wins", (Object)"toggle -a*", (Object)opts.getOption("a").getDescription());
    }

    @Test
    public void testLong() {
        Options opts = new Options();
        opts.addOption("a", "--a", false, "toggle -a");
        opts.addOption("b", "--b", true, "set -b");
        Assert.assertTrue((boolean)opts.hasOption("a"));
        Assert.assertTrue((boolean)opts.hasOption("b"));
    }

    @Test
    public void testDuplicateLong() {
        Options opts = new Options();
        opts.addOption("a", "--a", false, "toggle -a");
        opts.addOption("a", "--a", false, "toggle -a*");
        Assert.assertEquals((String)"last one in wins", (Object)"toggle -a*", (Object)opts.getOption("a").getDescription());
    }

    @Test
    public void testHelpOptions() {
        OptionBuilder.withLongOpt((String)"long-only1");
        Option longOnly1 = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"long-only2");
        Option longOnly2 = OptionBuilder.create();
        Option shortOnly1 = OptionBuilder.create((String)"1");
        Option shortOnly2 = OptionBuilder.create((String)"2");
        OptionBuilder.withLongOpt((String)"bothA");
        Option bothA = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"bothB");
        Option bothB = OptionBuilder.create((String)"b");
        Options options = new Options();
        options.addOption(longOnly1);
        options.addOption(longOnly2);
        options.addOption(shortOnly1);
        options.addOption(shortOnly2);
        options.addOption(bothA);
        options.addOption(bothB);
        ArrayList<Option> allOptions = new ArrayList<Option>();
        allOptions.add(longOnly1);
        allOptions.add(longOnly2);
        allOptions.add(shortOnly1);
        allOptions.add(shortOnly2);
        allOptions.add(bothA);
        allOptions.add(bothB);
        List helpOptions = options.helpOptions();
        Assert.assertTrue((String)"Everything in all should be in help", (boolean)helpOptions.containsAll(allOptions));
        Assert.assertTrue((String)"Everything in help should be in all", (boolean)allOptions.containsAll(helpOptions));
    }

    @Test
    public void testMissingOptionException() throws ParseException {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        try {
            new PosixParser().parse(options, new String[0]);
            Assert.fail((String)"Expected MissingOptionException to be thrown");
        }
        catch (MissingOptionException e) {
            Assert.assertEquals((Object)"Missing required option: f", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingOptionsException() throws ParseException {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"x"));
        try {
            new PosixParser().parse(options, new String[0]);
            Assert.fail((String)"Expected MissingOptionException to be thrown");
        }
        catch (MissingOptionException e) {
            Assert.assertEquals((Object)"Missing required options: f, x", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        Options options = new Options();
        options.addOption("f", "foo", true, "Foo");
        options.addOption("b", "bar", false, "Bar");
        String s = options.toString();
        Assert.assertNotNull((String)"null string returned", (Object)s);
        Assert.assertTrue((String)"foo option missing", (boolean)s.toLowerCase().contains("foo"));
        Assert.assertTrue((String)"bar option missing", (boolean)s.toLowerCase().contains("bar"));
    }

    @Test
    public void testGetOptionsGroups() {
        Options options = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(OptionBuilder.create((char)'a'));
        group1.addOption(OptionBuilder.create((char)'b'));
        OptionGroup group2 = new OptionGroup();
        group2.addOption(OptionBuilder.create((char)'x'));
        group2.addOption(OptionBuilder.create((char)'y'));
        options.addOptionGroup(group1);
        options.addOptionGroup(group2);
        Assert.assertNotNull((Object)options.getOptionGroups());
        Assert.assertEquals((long)2L, (long)options.getOptionGroups().size());
    }

    @Test
    public void testGetMatchingOpts() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        Assert.assertTrue((boolean)options.getMatchingOptions("foo").isEmpty());
        Assert.assertEquals((long)1L, (long)options.getMatchingOptions("version").size());
        Assert.assertEquals((long)2L, (long)options.getMatchingOptions("ver").size());
    }
}

