/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArgumentIsOptionTest {
    private Options options = null;
    private CommandLineParser parser = null;

    @Before
    public void setUp() {
        this.options = new Options().addOption("p", false, "Option p").addOption("attr", true, "Option accepts argument");
        this.parser = new PosixParser();
    }

    @Test
    public void testOptionAndOptionWithArgument() throws Exception {
        String[] args = new String[]{"-p", "-attr", "p"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -p is set", (boolean)cl.hasOption("p"));
        Assert.assertTrue((String)"Confirm -attr is set", (boolean)cl.hasOption("attr"));
        Assert.assertTrue((String)"Confirm arg of -attr", (boolean)cl.getOptionValue("attr").equals("p"));
        Assert.assertTrue((String)"Confirm all arguments recognized", (cl.getArgs().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOptionWithArgument() throws Exception {
        String[] args = new String[]{"-attr", "p"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertFalse((String)"Confirm -p is set", (boolean)cl.hasOption("p"));
        Assert.assertTrue((String)"Confirm -attr is set", (boolean)cl.hasOption("attr"));
        Assert.assertTrue((String)"Confirm arg of -attr", (boolean)cl.getOptionValue("attr").equals("p"));
        Assert.assertTrue((String)"Confirm all arguments recognized", (cl.getArgs().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOption() throws Exception {
        String[] args = new String[]{"-p"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -p is set", (boolean)cl.hasOption("p"));
        Assert.assertFalse((String)"Confirm -attr is not set", (boolean)cl.hasOption("attr"));
        Assert.assertTrue((String)"Confirm all arguments recognized", (cl.getArgs().length == 0 ? 1 : 0) != 0);
    }
}

