/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.bugs.other.Jira273BeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira273Test {
    private static final Log LOG = LogFactory.getLog(Jira273Test.class);

    @BeforeEach
    protected void setUp() throws Exception {
    }

    @AfterEach
    protected void tearDown() throws Exception {
    }

    @Test
    public void testIssue_BEANUTILS_273_AnonymousNotOverridden() throws Exception {
        Object bean = Jira273BeanFactory.createAnonymousNotOverridden();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        Assertions.assertEquals((Object)"PublicBeanWithMethod", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_273_AnonymousOverridden() throws Exception {
        Object bean = Jira273BeanFactory.createAnonymousOverridden();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        Assertions.assertEquals((Object)"AnonymousOverridden", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_273_PrivatePrivatePublicNotOverridden() throws Exception {
        Object bean = Jira273BeanFactory.createPrivatePrivatePublicNotOverridden();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        Assertions.assertEquals((Object)"PublicBeanWithMethod", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_273_PrivatePrivatePublicOverridden() throws Exception {
        Object bean = Jira273BeanFactory.createPrivatePrivatePublicOverridden();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        Assertions.assertEquals((Object)"PrivatePrivatePublicOverridden", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_273_PrivatePublicNotOverridden() throws Exception {
        Object bean = Jira273BeanFactory.createPrivatePublicNotOverridden();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        Assertions.assertEquals((Object)"PublicBeanWithMethod", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_273_PrivatePublicOverridden() throws Exception {
        Object bean = Jira273BeanFactory.createPrivatePublicOverridden();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        Assertions.assertEquals((Object)"PrivatePublicOverridden", (Object)result);
    }
}

