/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils2.AlphaBean;
import org.apache.commons.beanutils2.BetaBean;
import org.apache.commons.beanutils2.MethodUtils;
import org.apache.commons.beanutils2.PrimitiveBean;
import org.apache.commons.beanutils2.TestBean;
import org.apache.commons.beanutils2.priv.PrivateBeanFactory;
import org.apache.commons.beanutils2.priv.PublicSubBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class MethodUtilsTest {
    private static void assertMethod(Method method, String methodName) {
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)methodName, (Object)method.getName(), (String)"Method is not named correctly");
        Assertions.assertTrue((boolean)Modifier.isPublic(method.getModifiers()), (String)"Method is not public");
    }

    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testClearCache() throws Exception {
        MethodUtils.clearCache();
        PublicSubBean bean = new PublicSubBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        Assertions.assertEquals((int)1, (int)MethodUtils.clearCache());
        Assertions.assertEquals((int)0, (int)MethodUtils.clearCache());
    }

    @Test
    public void testGetAccessibleMethod() {
        Method method = MethodUtils.getAccessibleMethod(TestBean.class, (String)"setStringProperty", String.class);
        MethodUtilsTest.assertMethod(method, "setStringProperty");
    }

    @Test
    public void testGetAccessibleMethodFromInterface() {
        Method method = MethodUtils.getAccessibleMethod(PrivateBeanFactory.create().getClass(), (String)"methodBar", String.class);
        MethodUtilsTest.assertMethod(method, "methodBar");
    }

    @Test
    public void testGetAccessibleMethodIndirectInterface() {
        Method method = MethodUtils.getAccessibleMethod(PrivateBeanFactory.createSubclass().getClass(), (String)"methodBaz", String.class);
        MethodUtilsTest.assertMethod(method, "methodBaz");
    }

    @Test
    public void testInvokeExactMethod() throws Exception {
        TestBean bean = new TestBean();
        Object ret = MethodUtils.invokeExactMethod((Object)bean, (String)"setStringProperty", (Object)"TEST");
        Assertions.assertNull((Object)ret);
        Assertions.assertEquals((Object)"TEST", (Object)bean.getStringProperty(), (String)"Method ONE was invoked");
    }

    @Test
    public void testInvokeExactMethodFromInterface() throws Exception {
        Object ret = MethodUtils.invokeExactMethod((Object)PrivateBeanFactory.create(), (String)"methodBar", (Object)"ANOTHER TEST");
        Assertions.assertEquals((Object)"ANOTHER TEST", (Object)ret, (String)"Method TWO wasn't invoked correctly");
    }

    @Test
    public void testInvokeExactMethodIndirectInterface() throws Exception {
        Object ret = MethodUtils.invokeExactMethod((Object)PrivateBeanFactory.createSubclass(), (String)"methodBaz", (Object)"YET ANOTHER TEST");
        Assertions.assertEquals((Object)"YET ANOTHER TEST", (Object)ret, (String)"Method TWO was invoked correctly");
    }

    @Test
    public void testInvokeExactMethodNull() throws Exception {
        Object object = new Object();
        Object result = MethodUtils.invokeExactMethod((Object)object, (String)"toString", null);
        Assertions.assertEquals((Object)object.toString(), (Object)result);
    }

    @Test
    public void testInvokeExactMethodNullArray() throws Exception {
        Object result = MethodUtils.invokeExactMethod((Object)new AlphaBean("parent"), (String)"getName", null);
        Assertions.assertEquals((Object)"parent", (Object)result);
    }

    @Test
    public void testInvokeExactMethodNullArrayNullArray() throws Exception {
        Object result = MethodUtils.invokeExactMethod((Object)new AlphaBean("parent"), (String)"getName", null, null);
        Assertions.assertEquals((Object)"parent", (Object)result);
    }

    @Test
    public void testInvokeExactStaticMethodNull() throws Exception {
        int current = TestBean.currentCounter();
        Object value = MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"currentCounter", null);
        Assertions.assertEquals((int)current, (int)((Integer)value), (String)"currentCounter value");
    }

    @Test
    public void testInvokeMethod() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        BetaBean childOne = new BetaBean("ChildOne");
        Assertions.assertEquals((Object)"ChildOne", (Object)MethodUtils.invokeMethod((Object)parent, (String)"testAddChild", (Object)childOne), (String)"Cannot invoke through abstract class (1)");
    }

    @Test
    public void testInvokeMethodArray() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        AlphaBean childTwo = new AlphaBean("ChildTwo");
        Object[] params = new Object[]{"parameter", childTwo};
        Assertions.assertEquals((Object)"ChildTwo", (Object)MethodUtils.invokeMethod((Object)parent, (String)"testAddChild2", (Object[])params), (String)"Cannot invoke through abstract class");
    }

    @Test
    public void testInvokeMethodNull() throws Exception {
        Object object = new Object();
        Object result = MethodUtils.invokeMethod((Object)object, (String)"toString", null);
        Assertions.assertEquals((Object)object.toString(), (Object)result);
    }

    @Test
    public void testInvokeMethodNullArray() throws Exception {
        Object result = MethodUtils.invokeMethod((Object)new AlphaBean("parent"), (String)"getName", null);
        Assertions.assertEquals((Object)"parent", (Object)result);
    }

    @Test
    public void testInvokeMethodNullArrayNullArray() throws Exception {
        Object result = MethodUtils.invokeMethod((Object)new AlphaBean("parent"), (String)"getName", null, null);
        Assertions.assertEquals((Object)"parent", (Object)result);
    }

    @Test
    public void testInvokeMethodObject() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        AlphaBean childTwo = new AlphaBean("ChildTwo");
        Assertions.assertEquals((Object)"ChildTwo", (Object)MethodUtils.invokeMethod((Object)parent, (String)"testAddChild", (Object)childTwo), (String)"Cannot invoke through interface (1)");
    }

    @Test
    public void testInvokeMethodPrimitiveBoolean() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setBoolean", (Object)Boolean.FALSE);
        Assertions.assertEquals((Object)false, (Object)bean.getBoolean(), (String)"Call boolean property using invokeMethod");
    }

    @Test
    public void testInvokeMethodPrimitiveDouble() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setDouble", (Object)25.5);
        Assertions.assertEquals((double)25.5, (double)bean.getDouble(), (double)0.01, (String)"Set double property using invokeMethod");
    }

    @Test
    public void testInvokeMethodPrimitiveFloat() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFloat", (Object)Float.valueOf(20.0f));
        Assertions.assertEquals((float)20.0f, (float)bean.getFloat(), (float)0.01f, (String)"Call float property using invokeMethod");
    }

    @Test
    public void testInvokeMethodPrimitiveInt() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setInt", (Object)12);
        Assertions.assertEquals((int)12, (int)bean.getInt(), (String)"Set int property using invokeMethod");
    }

    @Test
    public void testInvokeMethodPrimitiveLong() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setLong", (Object)10L);
        Assertions.assertEquals((long)10L, (long)bean.getLong(), (String)"Call long property using invokeMethod");
    }

    @Test
    public void testInvokeMethodUnknown() throws Exception {
        AlphaBean parent = new AlphaBean("parent");
        BetaBean childOne = new BetaBean("ChildOne");
        Assertions.assertThrows(NoSuchMethodException.class, () -> MethodUtils.invokeMethod((Object)parent, (String)"bogus", (Object)childOne));
    }

    @Test
    public void testInvokeStaticMethodNull() throws Exception {
        int current = TestBean.currentCounter();
        Object value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", null);
        Assertions.assertEquals((int)current, (int)((Integer)value), (String)"currentCounter value");
    }

    @Test
    public void testNoCaching() throws Exception {
        MethodUtils.setCacheMethods((boolean)false);
        PublicSubBean bean = new PublicSubBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        Assertions.assertEquals((int)0, (int)MethodUtils.clearCache());
        MethodUtils.setCacheMethods((boolean)true);
    }

    @Test
    public void testParentMethod() throws Exception {
        String a = "A";
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            String actual1 = (String)MethodUtils.invokeMethod((Object)"A", (String)"toLowerCase", null);
            Assertions.assertEquals((Object)"a", (Object)actual1);
        }, () -> {
            char actual2 = ((Character)MethodUtils.invokeMethod((Object)"A", (String)"charAt", (Object)0)).charValue();
            Assertions.assertEquals((char)'A', (char)actual2);
        }});
    }

    @Test
    public void testPublicSub() throws Exception {
        PublicSubBean bean = new PublicSubBean();
        Assertions.assertEquals((Object)bean.getFoo(), (Object)"This is foo", (String)"Start value (foo)");
        Assertions.assertEquals((Object)bean.getBar(), (Object)"This is bar", (String)"Start value (bar)");
        bean.setFoo("new foo");
        bean.setBar("new bar");
        Assertions.assertEquals((Object)bean.getFoo(), (Object)"new foo", (String)"Set value (foo)");
        Assertions.assertEquals((Object)bean.getBar(), (Object)"new bar", (String)"Set value (bar)");
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        Assertions.assertEquals((Object)bean.getFoo(), (Object)"alpha", (String)"Set value (foo:2)");
        MethodUtils.invokeMethod((Object)bean, (String)"setBar", (Object)"beta");
        Assertions.assertEquals((Object)bean.getBar(), (Object)"beta", (String)"Set value (bar:2)");
        Method method = MethodUtils.getAccessibleMethod(PublicSubBean.class, (String)"setFoo", String.class);
        Assertions.assertNotNull((Object)method, (String)"getAccessibleMethod() setFoo is Null");
        method.invoke((Object)bean, "1111");
        Assertions.assertEquals((Object)"1111", (Object)bean.getFoo(), (String)"Set value (foo:3)");
        method = MethodUtils.getAccessibleMethod(PublicSubBean.class, (String)"setBar", String.class);
        Assertions.assertNotNull((Object)method, (String)"getAccessibleMethod() setBar is Null");
        method.invoke((Object)bean, "2222");
        Assertions.assertEquals((Object)"2222", (Object)bean.getBar(), (String)"Set value (bar:3)");
    }

    @Test
    public void testSetCacheMethods() throws Exception {
        MethodUtils.setCacheMethods((boolean)true);
        MethodUtils.clearCache();
        PublicSubBean bean = new PublicSubBean();
        MethodUtils.invokeMethod((Object)bean, (String)"setFoo", (Object)"alpha");
        Assertions.assertEquals((int)1, (int)MethodUtils.clearCache());
        Assertions.assertEquals((int)0, (int)MethodUtils.clearCache());
    }

    @Test
    public void testSimpleStatic1() throws Exception {
        TestBean bean = new TestBean();
        Object value = null;
        int current = TestBean.currentCounter();
        value = MethodUtils.invokeMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)current, (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[0], (Class[])new Class[0]);
        value = MethodUtils.invokeMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)(++current), (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[]{5}, (Class[])new Class[]{Integer.TYPE});
        value = MethodUtils.invokeMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)(current += 5), (int)((Integer)value), (String)"currentCounter value");
    }

    @Test
    public void testSimpleStatic2() throws Exception {
        TestBean bean = new TestBean();
        Object value = null;
        int current = TestBean.currentCounter();
        value = MethodUtils.invokeExactMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)current, (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeExactMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[0], (Class[])new Class[0]);
        value = MethodUtils.invokeExactMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)(++current), (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeExactMethod((Object)bean, (String)"incrementCounter", (Object[])new Object[]{5}, (Class[])new Class[]{Integer.TYPE});
        value = MethodUtils.invokeExactMethod((Object)bean, (String)"currentCounter", (Object[])new Object[0], (Class[])new Class[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)(current += 5), (int)((Integer)value), (String)"currentCounter value");
    }

    @Test
    public void testSimpleStatic3() throws Exception {
        Object value = null;
        int current = TestBean.currentCounter();
        Method currentCounterMethod = MethodUtils.getAccessibleMethod(TestBean.class, (String)"currentCounter", (Class[])new Class[0]);
        Assertions.assertNotNull((Object)currentCounterMethod, (String)"currentCounterMethod exists");
        Assertions.assertEquals((Object)"currentCounter", (Object)currentCounterMethod.getName(), (String)"currentCounterMethod name");
        Assertions.assertEquals((int)0, (int)currentCounterMethod.getParameterTypes().length, (String)"currentCounterMethod args");
        Assertions.assertTrue((boolean)Modifier.isPublic(currentCounterMethod.getModifiers()), (String)"currentCounterMethod public");
        Assertions.assertTrue((boolean)Modifier.isStatic(currentCounterMethod.getModifiers()), (String)"currentCounterMethod static");
        Method incrementCounterMethod1 = MethodUtils.getAccessibleMethod(TestBean.class, (String)"incrementCounter", (Class[])new Class[0]);
        Assertions.assertNotNull((Object)incrementCounterMethod1, (String)"incrementCounterMethod1 exists");
        Assertions.assertEquals((Object)"incrementCounter", (Object)incrementCounterMethod1.getName(), (String)"incrementCounterMethod1 name");
        Assertions.assertEquals((int)0, (int)incrementCounterMethod1.getParameterTypes().length, (String)"incrementCounterMethod1 args");
        Assertions.assertTrue((boolean)Modifier.isPublic(incrementCounterMethod1.getModifiers()), (String)"incrementCounterMethod1 public");
        Assertions.assertTrue((boolean)Modifier.isStatic(incrementCounterMethod1.getModifiers()), (String)"incrementCounterMethod1 static");
        Method incrementCounterMethod2 = MethodUtils.getAccessibleMethod(TestBean.class, (String)"incrementCounter", (Class[])new Class[]{Integer.TYPE});
        Assertions.assertNotNull((Object)incrementCounterMethod2, (String)"incrementCounterMethod2 exists");
        Assertions.assertEquals((Object)"incrementCounter", (Object)incrementCounterMethod2.getName(), (String)"incrementCounterMethod2 name");
        Assertions.assertEquals((int)1, (int)incrementCounterMethod2.getParameterTypes().length, (String)"incrementCounterMethod2 args");
        Assertions.assertTrue((boolean)Modifier.isPublic(incrementCounterMethod2.getModifiers()), (String)"incrementCounterMethod2 public");
        Assertions.assertTrue((boolean)Modifier.isStatic(incrementCounterMethod2.getModifiers()), (String)"incrementCounterMethod2 static");
        value = currentCounterMethod.invoke(null, new Object[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)current, (int)((Integer)value), (String)"currentCounter value");
        incrementCounterMethod1.invoke(null, new Object[0]);
        value = currentCounterMethod.invoke(null, new Object[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)(++current), (int)((Integer)value), (String)"currentCounter value");
        incrementCounterMethod2.invoke(null, 5);
        value = currentCounterMethod.invoke(null, new Object[0]);
        Assertions.assertNotNull((Object)value, (String)"currentCounter exists");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"currentCounter type");
        Assertions.assertEquals((int)(current += 5), (int)((Integer)value), (String)"currentCounter value");
    }

    @Test
    public void testStaticInvokeMethod() throws Exception {
        int current = TestBean.currentCounter();
        Object value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        Assertions.assertEquals((int)current, (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeStaticMethod(TestBean.class, (String)"incrementCounter", (Object[])new Object[0]);
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        Assertions.assertEquals((int)(++current), (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeStaticMethod(TestBean.class, (String)"incrementCounter", (Object[])new Object[]{8});
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        Assertions.assertEquals((int)(current += 8), (int)((Integer)value), (String)"currentCounter value");
        MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"incrementCounter", (Object[])new Object[]{8}, (Class[])new Class[]{Number.class});
        value = MethodUtils.invokeStaticMethod(TestBean.class, (String)"currentCounter", (Object[])new Object[0]);
        Assertions.assertEquals((int)(current += 16), (int)((Integer)value), (String)"currentCounter value");
    }
}

