/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import org.apache.commons.beanutils2.AlphaBean;
import org.apache.commons.beanutils2.BeanComparator;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BeanComparatorTest {
    protected TestBean bean;
    protected AlphaBean alphaBean1;
    protected AlphaBean alphaBean2;

    @BeforeEach
    public void setUp() {
        this.bean = new TestBean();
        this.alphaBean1 = new AlphaBean("alphaBean1");
        this.alphaBean2 = new AlphaBean("alphaBean2");
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
        this.alphaBean1 = null;
        this.alphaBean2 = null;
    }

    @Test
    public void testCompareBeanAgainstSelf() {
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean1, (Object)this.alphaBean1);
        Assertions.assertEquals((int)0, (int)result, () -> "Comparator did not sort properly.  Result:" + result);
    }

    @Test
    public void testCompareIdentical() {
        this.alphaBean1 = new AlphaBean("alphabean");
        this.alphaBean2 = new AlphaBean("alphabean");
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean1, (Object)this.alphaBean2);
        Assertions.assertEquals((int)0, (int)result, () -> "Comparator did not sort properly.  Result:" + result);
    }

    @Test
    public void testCompareOnBooleanProperty() {
        try {
            TestBean testBeanA = new TestBean();
            TestBean testBeanB = new TestBean();
            testBeanA.setBooleanProperty(true);
            testBeanB.setBooleanProperty(false);
            BeanComparator beanComparator = new BeanComparator("booleanProperty");
            beanComparator.compare((Object)testBeanA, (Object)testBeanB);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testCompareOnMissingProperty() {
        BeanComparator beanComparator = new BeanComparator("bogusName");
        Exception e = (Exception)Assertions.assertThrows(RuntimeException.class, () -> beanComparator.compare((Object)this.alphaBean2, (Object)this.alphaBean1));
        Assertions.assertTrue((boolean)e.toString().contains("Unknown property"), () -> "Wrong exception was thrown: " + e);
    }

    @Test
    public void testCompareWithNulls() {
        BeanComparator beanComparator = new BeanComparator("name");
        Assertions.assertThrows(NullPointerException.class, () -> beanComparator.compare((Object)this.alphaBean2, null));
    }

    @Test
    public void testSetProperty() {
        TestBean testBeanA = new TestBean();
        TestBean testBeanB = new TestBean();
        testBeanA.setDoubleProperty(5.5);
        testBeanB.setDoubleProperty(1.0);
        BeanComparator beanComparator = new BeanComparator("doubleProperty");
        int result1 = beanComparator.compare((Object)testBeanA, (Object)testBeanB);
        Assertions.assertEquals((int)1, (int)result1, () -> "Comparator did not sort properly.  Result:" + result1);
        testBeanA.setStringProperty("string 1");
        testBeanB.setStringProperty("string 2");
        beanComparator.setProperty("stringProperty");
        int result2 = beanComparator.compare((Object)testBeanA, (Object)testBeanB);
        Assertions.assertEquals((int)-1, (int)result2, () -> "Comparator did not sort properly.  Result:" + result2);
    }

    @Test
    public void testSimpleCompare() {
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean1, (Object)this.alphaBean2);
        Assertions.assertEquals((int)-1, (int)result, () -> "Comparator did not sort properly.  Result:" + result);
    }

    @Test
    public void testSimpleCompareInverse() {
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean2, (Object)this.alphaBean1);
        Assertions.assertEquals((int)1, (int)result, () -> "Comparator did not sort properly.  Result:" + result);
    }
}

