/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.expression;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.expression.DefaultResolver;

public class DefaultResolverTestCase
extends TestCase {
    private final DefaultResolver resolver = new DefaultResolver();
    private final String[] validProperties = new String[]{null, "", "a", "bc", "def", "g.h", "ij.k", "lm.no", "pqr.stu"};
    private final String[] validNames = new String[]{null, "", "a", "bc", "def", "g", "ij", "lm", "pqr"};
    private final String[] validIndexProperties = new String[]{"a[1]", "b[12]", "cd[3]", "ef[45]", "ghi[6]", "jkl[789]"};
    private final String[] validIndexNames = new String[]{"a", "b", "cd", "ef", "ghi", "jkl"};
    private final int[] validIndexValues = new int[]{1, 12, 3, 45, 6, 789};
    private final String[] validMapProperties = new String[]{"a(b)", "c(de)", "fg(h)", "ij(kl)", "mno(pqr.s)", "tuv(wx).yz[1]"};
    private final String[] validMapNames = new String[]{"a", "c", "fg", "ij", "mno", "tuv"};
    private final String[] validMapKeys = new String[]{"b", "de", "h", "kl", "pqr.s", "wx"};
    private final String[] nextExpressions = new String[]{"a", "bc", "d.e", "fg.h", "ij.kl", "m(12)", "no(3.4)", "pq(r).s", "t[12]", "uv[34].wx"};
    private final String[] nextProperties = new String[]{"a", "bc", "d", "fg", "ij", "m(12)", "no(3.4)", "pq(r)", "t[12]", "uv[34]"};
    private final String[] removeProperties = new String[]{null, null, "e", "h", "kl", null, null, "s", null, "wx"};

    public DefaultResolverTestCase(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(DefaultResolverTestCase.class);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testGetIndex() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            try {
                label = "Simple " + this.label(this.validProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (int)-1, (int)this.resolver.getIndex(this.validProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            try {
                label = "Indexed " + this.label(this.validIndexProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (int)this.validIndexValues[i], (int)this.resolver.getIndex(this.validIndexProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            try {
                label = "Mapped " + this.label(this.validMapProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (int)-1, (int)this.resolver.getIndex(this.validMapProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        label = "Missing Index";
        try {
            int index = this.resolver.getIndex("foo[]");
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + index));
        }
        catch (IllegalArgumentException e) {
            DefaultResolverTestCase.assertEquals((String)(label + " Error Message"), (String)"No Index Value", (String)e.getMessage());
        }
        catch (Throwable t) {
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + t));
        }
        label = "Malformed";
        try {
            int index = this.resolver.getIndex("foo[12");
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + index));
        }
        catch (IllegalArgumentException e) {
            DefaultResolverTestCase.assertEquals((String)(label + " Error Message"), (String)"Missing End Delimiter", (String)e.getMessage());
        }
        catch (Throwable t) {
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + t));
        }
        label = "Malformed";
        try {
            int index = this.resolver.getIndex("foo[BAR]");
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + index));
        }
        catch (IllegalArgumentException e) {
            DefaultResolverTestCase.assertEquals((String)(label + " Error Message"), (String)"Invalid index value 'BAR'", (String)e.getMessage());
        }
        catch (Throwable t) {
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + t));
        }
    }

    public void testGetMapKey() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            try {
                label = "Simple " + this.label(this.validProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, null, (String)this.resolver.getKey(this.validProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            try {
                label = "Indexed " + this.label(this.validIndexProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, null, (String)this.resolver.getKey(this.validIndexProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            try {
                label = "Mapped " + this.label(this.validMapProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (String)this.validMapKeys[i], (String)this.resolver.getKey(this.validMapProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        label = "Malformed";
        try {
            String key = this.resolver.getKey("foo(bar");
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + key));
        }
        catch (IllegalArgumentException e) {
            DefaultResolverTestCase.assertEquals((String)(label + " Error Message"), (String)"Missing End Delimiter", (String)e.getMessage());
        }
        catch (Throwable t) {
            DefaultResolverTestCase.fail((String)(label + " expected IllegalArgumentException: " + t));
        }
    }

    public void testIsIndexed() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            try {
                label = "Simple " + this.label(this.validProperties[i], i);
                DefaultResolverTestCase.assertFalse((String)label, (boolean)this.resolver.isIndexed(this.validProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            try {
                label = "Indexed " + this.label(this.validIndexProperties[i], i);
                DefaultResolverTestCase.assertTrue((String)label, (boolean)this.resolver.isIndexed(this.validIndexProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            try {
                label = "Mapped " + this.label(this.validMapProperties[i], i);
                DefaultResolverTestCase.assertFalse((String)label, (boolean)this.resolver.isIndexed(this.validMapProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
    }

    public void testIsMapped() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            try {
                label = "Simple " + this.label(this.validProperties[i], i);
                DefaultResolverTestCase.assertFalse((String)label, (boolean)this.resolver.isMapped(this.validProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            try {
                label = "Indexed " + this.label(this.validIndexProperties[i], i);
                DefaultResolverTestCase.assertFalse((String)label, (boolean)this.resolver.isMapped(this.validIndexProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            try {
                label = "Mapped " + this.label(this.validMapProperties[i], i);
                DefaultResolverTestCase.assertTrue((String)label, (boolean)this.resolver.isMapped(this.validMapProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
    }

    public void testGetName() {
        int i;
        String label = null;
        for (i = 0; i < this.validProperties.length; ++i) {
            try {
                label = "Simple " + this.label(this.validProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (String)this.validNames[i], (String)this.resolver.getProperty(this.validProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validIndexProperties.length; ++i) {
            try {
                label = "Indexed " + this.label(this.validIndexProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (String)this.validIndexNames[i], (String)this.resolver.getProperty(this.validIndexProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
        for (i = 0; i < this.validMapProperties.length; ++i) {
            try {
                label = "Mapped " + this.label(this.validMapProperties[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (String)this.validMapNames[i], (String)this.resolver.getProperty(this.validMapProperties[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
    }

    public void testNext() {
        String label = null;
        for (int i = 0; i < this.nextExpressions.length; ++i) {
            try {
                label = this.label(this.nextExpressions[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (String)this.nextProperties[i], (String)this.resolver.next(this.nextExpressions[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
    }

    public void testRemove() {
        String label = null;
        for (int i = 0; i < this.nextExpressions.length; ++i) {
            try {
                label = this.label(this.nextExpressions[i], i);
                DefaultResolverTestCase.assertEquals((String)label, (String)this.removeProperties[i], (String)this.resolver.remove(this.nextExpressions[i]));
                continue;
            }
            catch (Throwable t) {
                DefaultResolverTestCase.fail((String)(label + " threw " + t));
            }
        }
    }

    private String label(String expression, int i) {
        return "Expression[" + i + "]=\"" + expression + "\"";
    }
}

