/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.NumberConverter;

public abstract class NumberConverterTestBase
extends TestCase {
    protected Number[] numbers = new Number[4];

    public NumberConverterTestBase(String name) {
        super(name);
    }

    protected abstract NumberConverter makeConverter();

    protected abstract NumberConverter makeConverter(Object var1);

    protected abstract Class<?> getExpectedType();

    public void testConvertNull() {
        try {
            this.makeConverter().convert(this.getExpectedType(), null);
            NumberConverterTestBase.fail((String)"Expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testConvertNumber() {
        String[] message = new String[]{"from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double", "from BigDecimal", "from BigInteger", "from Integer array"};
        Object[] number = new Object[]{new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2), new BigDecimal("17.2"), new BigInteger("33"), new Integer[]{new Integer(3), new Integer(2), new Integer(1)}};
        for (int i = 0; i < number.length; ++i) {
            Object val = this.makeConverter().convert(this.getExpectedType(), number[i]);
            NumberConverterTestBase.assertNotNull((String)("Convert " + message[i] + " should not be null"), (Object)val);
            NumberConverterTestBase.assertTrue((String)("Convert " + message[i] + " should return a " + this.getExpectedType().getName()), (boolean)this.getExpectedType().isInstance(val));
        }
    }

    public void testNumberToStringPattern() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter converter = this.makeConverter();
        converter.setPattern("[0,0.0];(0,0.0)");
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[0]), (String)"(12.0)", (String)((String)converter.convert(String.class, (Object)this.numbers[0])));
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[1]), (String)"[13.0]", (String)((String)converter.convert(String.class, (Object)this.numbers[1])));
        converter.setLocale(Locale.GERMAN);
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[2]), (String)"(22,0)", (String)((String)converter.convert(String.class, (Object)this.numbers[2])));
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[3]), (String)"[23,0]", (String)((String)converter.convert(String.class, (Object)this.numbers[3])));
        Locale.setDefault(defaultLocale);
    }

    public void testNumberToStringLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[0]), (String)"-12", (String)((String)converter.convert(String.class, (Object)this.numbers[0])));
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[1]), (String)"13", (String)((String)converter.convert(String.class, (Object)this.numbers[1])));
        converter.setLocale(Locale.GERMAN);
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[2]), (String)"-22", (String)((String)converter.convert(String.class, (Object)this.numbers[2])));
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[3]), (String)"23", (String)((String)converter.convert(String.class, (Object)this.numbers[3])));
        Locale.setDefault(defaultLocale);
    }

    public void testStringArrayToInteger() {
        Integer defaultValue = new Integer(-1);
        NumberConverter converter = this.makeConverter(defaultValue);
        NumberConverterTestBase.assertEquals((String)"Valid First", (Object)new Integer(5), (Object)converter.convert(Integer.class, (Object)new String[]{"5", "4", "3"}));
        NumberConverterTestBase.assertEquals((String)"Invalid First", (Object)defaultValue, (Object)converter.convert(Integer.class, (Object)new String[]{"FOO", "1", "2"}));
        NumberConverterTestBase.assertEquals((String)"Null First", (Object)defaultValue, (Object)converter.convert(Integer.class, (Object)new String[]{null, "1", "2"}));
        NumberConverterTestBase.assertEquals((String)"Long Array", (Object)new Integer(9), (Object)converter.convert(Integer.class, (Object)new long[]{9L, 2L, 6L}));
    }

    public void testNumberToStringDefault() {
        NumberConverter converter = this.makeConverter();
        NumberConverterTestBase.assertEquals((String)("Default Convert " + this.numbers[0]), (String)this.numbers[0].toString(), (String)((String)converter.convert(String.class, (Object)this.numbers[0])));
        NumberConverterTestBase.assertEquals((String)("Default Convert " + this.numbers[1]), (String)this.numbers[1].toString(), (String)((String)converter.convert(String.class, (Object)this.numbers[1])));
    }

    public void testStringToNumberPattern() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter converter = this.makeConverter();
        converter.setPattern("[0,0];(0,0)");
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[0]), (Object)this.numbers[0], (Object)converter.convert(this.getExpectedType(), (Object)"(1,2)"));
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[1]), (Object)this.numbers[1], (Object)converter.convert(this.getExpectedType(), (Object)"[1,3]"));
        converter.setLocale(Locale.GERMAN);
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[2]), (Object)this.numbers[2], (Object)converter.convert(this.getExpectedType(), (Object)"(2.2)"));
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[3]), (Object)this.numbers[3], (Object)converter.convert(this.getExpectedType(), (Object)"[2.3]"));
        try {
            converter.convert(this.getExpectedType(), (Object)"1,2");
            NumberConverterTestBase.fail((String)"Expected invalid value to cause ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object obj = new Object(){

            public String toString() {
                return "dsdgsdsdg";
            }
        };
        try {
            converter.convert(this.getExpectedType(), obj);
            NumberConverterTestBase.fail((String)"Expected invalid value to cause ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale.setDefault(defaultLocale);
    }

    public void testStringToNumberLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[0]), (Object)this.numbers[0], (Object)converter.convert(this.getExpectedType(), (Object)"-0,012"));
        NumberConverterTestBase.assertEquals((String)("Default Locale " + this.numbers[1]), (Object)this.numbers[1], (Object)converter.convert(this.getExpectedType(), (Object)"0,013"));
        try {
            converter.convert(this.getExpectedType(), (Object)"0,02x");
            NumberConverterTestBase.fail((String)"Expected invalid value to cause ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        converter.setLocale(Locale.GERMAN);
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[2]), (Object)this.numbers[2], (Object)converter.convert(this.getExpectedType(), (Object)"-0.022"));
        NumberConverterTestBase.assertEquals((String)("Locale.GERMAN " + this.numbers[3]), (Object)this.numbers[3], (Object)converter.convert(this.getExpectedType(), (Object)"0.023"));
        try {
            converter.convert(this.getExpectedType(), (Object)"0.02x");
            NumberConverterTestBase.fail((String)"Expected invalid value to cause ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale.setDefault(defaultLocale);
    }

    public void testStringToNumberDefault() {
        NumberConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        NumberConverterTestBase.assertEquals((String)("Default Convert " + this.numbers[0]), (Object)this.numbers[0], (Object)converter.convert(this.getExpectedType(), (Object)this.numbers[0].toString()));
        try {
            converter.convert(this.getExpectedType(), (Object)"12x");
            NumberConverterTestBase.fail((String)"Expected invalid value to cause ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testStringToNumberDefaultType() {
        NumberConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        NumberConverterTestBase.assertEquals((String)("Default Convert " + this.numbers[0]), (Object)this.numbers[0], (Object)converter.convert(null, (Object)this.numbers[0].toString()));
    }

    public void testBooleanToNumberDefault() {
        NumberConverter converter = this.makeConverter();
        NumberConverterTestBase.assertEquals((String)"Boolean.FALSE to Number ", (int)0, (int)((Number)converter.convert(this.getExpectedType(), (Object)Boolean.FALSE)).intValue());
        NumberConverterTestBase.assertEquals((String)"Boolean.TRUE to Number ", (int)1, (int)((Number)converter.convert(this.getExpectedType(), (Object)Boolean.TRUE)).intValue());
    }

    public void testDateToNumber() {
        NumberConverter converter = this.makeConverter();
        Date dateValue = new Date();
        long longValue = dateValue.getTime();
        NumberConverterTestBase.assertEquals((String)"Date to Long", (Object)new Long(longValue), (Object)converter.convert(Long.class, (Object)dateValue));
        try {
            converter.convert(Integer.class, (Object)dateValue);
            NumberConverterTestBase.fail((String)"Date to Integer - expected a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testCalendarToNumber() {
        NumberConverter converter = this.makeConverter();
        Calendar calendarValue = Calendar.getInstance();
        long longValue = calendarValue.getTime().getTime();
        NumberConverterTestBase.assertEquals((String)"Calendar to Long", (Object)new Long(longValue), (Object)converter.convert(Long.class, (Object)calendarValue));
        try {
            converter.convert(Integer.class, (Object)calendarValue);
            NumberConverterTestBase.fail((String)"Calendar to Integer - expected a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testOtherToStringDefault() {
        NumberConverter converter = this.makeConverter();
        NumberConverterTestBase.assertEquals((String)"Default Convert ", (String)"ABC", (String)((String)converter.convert(String.class, (Object)new StringBuilder("ABC"))));
    }

    public void testInvalidDefault() {
        Number defaultvalue = this.numbers[0];
        NumberConverter converter = this.makeConverter(defaultvalue);
        NumberConverterTestBase.assertEquals((String)"Invalid null ", (Object)defaultvalue, (Object)converter.convert(this.getExpectedType(), null));
        NumberConverterTestBase.assertEquals((String)"Default XXXX ", (Object)defaultvalue, (Object)converter.convert(this.getExpectedType(), (Object)"XXXX"));
    }

    public void testInvalidException() {
        NumberConverter converter = this.makeConverter();
        try {
            converter.convert(this.getExpectedType(), null);
            NumberConverterTestBase.fail((String)"Null test, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            converter.convert(this.getExpectedType(), (Object)"XXXX");
            NumberConverterTestBase.fail((String)"Invalid test, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testInvalidType() {
        NumberConverter converter = this.makeConverter();
        try {
            converter.convert(Object.class, (Object)this.numbers[0]);
            NumberConverterTestBase.fail((String)"Invalid type test, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testInvalidTypeWithDefault() {
        NumberConverter converter = this.makeConverter(42);
        try {
            converter.convert(Object.class, (Object)this.numbers[0]);
            NumberConverterTestBase.fail((String)"Invalid type with default test, expected ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

