/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.beans.IntrospectionException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.memoryleaktests.MemoryLeakTestCase;

public class Jira347TestCase
extends TestCase {
    public void testMappedPropertyDescriptor_AnyArgsProperty() throws Exception {
        String className = "org.apache.commons.beanutils.MappedPropertyTestBean";
        URLClassLoader loader = Jira347TestCase.newClassLoader();
        Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils.MappedPropertyTestBean");
        beanClass.newInstance();
        Jira347TestCase.assertNotNull((String)"ClassLoader is null", (Object)loader);
        Jira347TestCase.assertNotNull((String)"BeanClass is null", beanClass);
        Jira347TestCase.assertNotSame((String)"ClassLoaders should be different..", (Object)((Object)((Object)this)).getClass().getClassLoader(), (Object)beanClass.getClassLoader());
        Jira347TestCase.assertSame((String)"BeanClass ClassLoader incorrect", (Object)beanClass.getClassLoader(), (Object)loader);
        MappedPropertyDescriptor descriptor = null;
        try {
            descriptor = new MappedPropertyDescriptor("anyMapped", beanClass);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (descriptor != null) {
            String m1 = this.getMappedWriteMethod(descriptor);
            this.forceGarbageCollection();
            try {
                String m2 = this.getMappedWriteMethod(descriptor);
                Jira347TestCase.assertEquals((String)"Method returned post garbage collection differs from Method returned prior to gc", (String)m1, (String)m2);
            }
            catch (RuntimeException e) {
                Jira347TestCase.fail((String)("getMappedWriteMethod threw an exception after garbage collection " + e));
            }
        }
    }

    private String getMappedWriteMethod(MappedPropertyDescriptor descriptor) {
        Method m = descriptor.getMappedWriteMethod();
        return m == null ? null : m.toString();
    }

    private void forceGarbageCollection() throws Exception {
        SoftReference<Object> ref = new SoftReference<Object>(new Object());
        int count = 0;
        while (ref.get() != null && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (ref.get() != null) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list.clear();
            list = null;
            System.gc();
            Thread.sleep(1000L);
        }
        if (ref.get() != null) {
            throw new IllegalStateException("Your JVM is not releasing SoftReference, try running the testcase with less memory (-Xmx)");
        }
    }

    private static URLClassLoader newClassLoader() throws MalformedURLException {
        String dataFilePath = MemoryLeakTestCase.class.getResource("pojotests").getFile();
        String location = "file://" + dataFilePath.substring(0, dataFilePath.length() - "org.apache.commons.beanutils.memoryleaktests.pojotests".length());
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < location.length(); ++i) {
            if (location.charAt(i) == '\\') {
                newString.append("/");
                continue;
            }
            newString.append(location.charAt(i));
        }
        String classLocation = newString.toString();
        URLClassLoader theLoader = URLClassLoader.newInstance(new URL[]{new URL(classLocation)}, null);
        return theLoader;
    }
}

