/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;

public class TestBean
implements Serializable {
    private boolean booleanProperty = true;
    private boolean booleanSecond = true;
    private byte byteProperty = (byte)121;
    private Date dateProperty;
    private Date[] dateArrayProperty;
    private double doubleProperty = 321.0;
    private String[] dupProperty = new String[]{"Dup 0", "Dup 1", "Dup 2", "Dup 3", "Dup 4"};
    private float floatProperty = 123.0f;
    private int[] intArray = new int[]{0, 10, 20, 30, 40};
    private final int[] intIndexed = new int[]{0, 10, 20, 30, 40};
    private int intProperty = 123;
    private List<Object> listIndexed = new ArrayList<Object>();
    private long longProperty = 321L;
    private Map<String, Object> mapProperty = null;
    private HashMap<String, Object> mappedObjects = null;
    private HashMap<String, String> mappedProperty = null;
    private HashMap<String, Integer> mappedIntProperty = null;
    private TestBean nested = null;
    private TestBean anotherNested = null;
    private DynaBean nestedDynaBean = null;
    private MappedTestBean mappedNested = null;
    private String nullProperty = null;
    private final String readOnlyProperty = "Read Only String Property";
    private short shortProperty = (short)987;
    private String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
    private final String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
    private String[][] string2dArray = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}};
    private String stringProperty = "This is a string";
    private String writeOnlyProperty = "Write Only String Property";
    private boolean invalidBoolean = false;
    private static int counter = 0;

    public TestBean() {
        this.listIndexed.add("String 0");
        this.listIndexed.add("String 1");
        this.listIndexed.add("String 2");
        this.listIndexed.add("String 3");
        this.listIndexed.add("String 4");
    }

    public TestBean(String stringProperty) {
        this.setStringProperty(stringProperty);
    }

    public TestBean(float floatProperty) {
        this.setFloatProperty(floatProperty);
    }

    public TestBean(boolean booleanProperty) {
        this.setBooleanProperty(booleanProperty);
    }

    public TestBean(Boolean booleanSecond) {
        this.setBooleanSecond(booleanSecond);
    }

    public TestBean(float floatProperty, String stringProperty) {
        this.setFloatProperty(floatProperty);
        this.setStringProperty(stringProperty);
    }

    public TestBean(boolean booleanProperty, String stringProperty) {
        this.setBooleanProperty(booleanProperty);
        this.setStringProperty(stringProperty);
    }

    public TestBean(Boolean booleanSecond, String stringProperty) {
        this.setBooleanSecond(booleanSecond);
        this.setStringProperty(stringProperty);
    }

    public TestBean(Integer intProperty) {
        this.setIntProperty(intProperty);
    }

    public TestBean(double doubleProperty) {
        this.setDoubleProperty(doubleProperty);
    }

    TestBean(int intProperty) {
        this.setIntProperty(intProperty);
    }

    protected TestBean(boolean booleanProperty, boolean booleanSecond, String stringProperty) {
        this.setBooleanProperty(booleanProperty);
        this.setBooleanSecond(booleanSecond);
        this.setStringProperty(stringProperty);
    }

    public TestBean(List<Object> listIndexed) {
        this.listIndexed = listIndexed;
    }

    public TestBean(String[][] string2dArray) {
        this.string2dArray = string2dArray;
    }

    public boolean getBooleanProperty() {
        return this.booleanProperty;
    }

    public void setBooleanProperty(boolean booleanProperty) {
        this.booleanProperty = booleanProperty;
    }

    public boolean isBooleanSecond() {
        return this.booleanSecond;
    }

    public void setBooleanSecond(boolean booleanSecond) {
        this.booleanSecond = booleanSecond;
    }

    public byte getByteProperty() {
        return this.byteProperty;
    }

    public void setByteProperty(byte byteProperty) {
        this.byteProperty = byteProperty;
    }

    public Date getDateProperty() {
        return this.dateProperty;
    }

    public void setDateProperty(Date dateProperty) {
        this.dateProperty = dateProperty;
    }

    public Date[] getDateArrayProperty() {
        return this.dateArrayProperty;
    }

    public void setDateArrayProperty(Date[] dateArrayProperty) {
        this.dateArrayProperty = dateArrayProperty;
    }

    public double getDoubleProperty() {
        return this.doubleProperty;
    }

    public void setDoubleProperty(double doubleProperty) {
        this.doubleProperty = doubleProperty;
    }

    public String[] getDupProperty() {
        return this.dupProperty;
    }

    public String getDupProperty(int index) {
        return this.dupProperty[index];
    }

    public void setDupProperty(int index, String value) {
        this.dupProperty[index] = value;
    }

    public void setDupProperty(String[] dupProperty) {
        this.dupProperty = dupProperty;
    }

    public float getFloatProperty() {
        return this.floatProperty;
    }

    public void setFloatProperty(float floatProperty) {
        this.floatProperty = floatProperty;
    }

    public int[] getIntArray() {
        return this.intArray;
    }

    public void setIntArray(int[] intArray) {
        this.intArray = intArray;
    }

    public int getIntIndexed(int index) {
        return this.intIndexed[index];
    }

    public void setIntIndexed(int index, int value) {
        this.intIndexed[index] = value;
    }

    public int getIntProperty() {
        return this.intProperty;
    }

    public void setIntProperty(int intProperty) {
        this.intProperty = intProperty;
    }

    public List<Object> getListIndexed() {
        return this.listIndexed;
    }

    public long getLongProperty() {
        return this.longProperty;
    }

    public void setLongProperty(long longProperty) {
        this.longProperty = longProperty;
    }

    public Map<String, Object> getMapProperty() {
        if (this.mapProperty == null) {
            this.mapProperty = new HashMap<String, Object>();
            this.mapProperty.put("First Key", "First Value");
            this.mapProperty.put("Second Key", "Second Value");
        }
        return this.mapProperty;
    }

    public void setMapProperty(Map<String, Object> mapProperty) {
        if (mapProperty == null) {
            mapProperty = new HashMap<String, Object>();
            mapProperty.put("First Key", "First Value");
            mapProperty.put("Second Key", "Second Value");
        }
        this.mapProperty = mapProperty;
    }

    public Object getMappedObjects(String key) {
        if (this.mappedObjects == null) {
            this.mappedObjects = new HashMap();
            this.mappedObjects.put("First Key", "First Value");
            this.mappedObjects.put("Second Key", "Second Value");
        }
        return this.mappedObjects.get(key);
    }

    public void setMappedObjects(String key, Object value) {
        if (this.mappedObjects == null) {
            this.mappedObjects = new HashMap();
            this.mappedObjects.put("First Key", "First Value");
            this.mappedObjects.put("Second Key", "Second Value");
        }
        this.mappedObjects.put(key, value);
    }

    public String getMappedProperty(String key) {
        if (this.mappedProperty == null) {
            this.mappedProperty = new HashMap();
            this.mappedProperty.put("First Key", "First Value");
            this.mappedProperty.put("Second Key", "Second Value");
        }
        return this.mappedProperty.get(key);
    }

    public void setMappedProperty(String key, String value) {
        if (this.mappedProperty == null) {
            this.mappedProperty = new HashMap();
            this.mappedProperty.put("First Key", "First Value");
            this.mappedProperty.put("Second Key", "Second Value");
        }
        this.mappedProperty.put(key, value);
    }

    public int getMappedIntProperty(String key) {
        Integer x;
        if (this.mappedIntProperty == null) {
            this.mappedIntProperty = new HashMap();
            this.mappedIntProperty.put("One", 1);
            this.mappedIntProperty.put("Two", 2);
        }
        return (x = this.mappedIntProperty.get(key)) == null ? 0 : x;
    }

    public void setMappedIntProperty(String key, int value) {
        this.mappedIntProperty.put(key, value);
    }

    public TestBean getNested() {
        if (this.nested == null) {
            this.nested = new TestBean();
        }
        return this.nested;
    }

    public TestBean getAnotherNested() {
        return this.anotherNested;
    }

    public void setAnotherNested(TestBean anotherNested) {
        this.anotherNested = anotherNested;
    }

    public DynaBean getNestedDynaBean() {
        return this.nestedDynaBean;
    }

    public void setNestedDynaBean(DynaBean nestedDynaBean) {
        this.nestedDynaBean = nestedDynaBean;
    }

    public MappedTestBean getMappedNested() {
        if (this.mappedNested == null) {
            this.mappedNested = new MappedTestBean();
        }
        return this.mappedNested;
    }

    public String getNullProperty() {
        return this.nullProperty;
    }

    public void setNullProperty(String nullProperty) {
        this.nullProperty = nullProperty;
    }

    public String getReadOnlyProperty() {
        return this.readOnlyProperty;
    }

    public short getShortProperty() {
        return this.shortProperty;
    }

    public void setShortProperty(short shortProperty) {
        this.shortProperty = shortProperty;
    }

    public String[] getStringArray() {
        return this.stringArray;
    }

    public void setStringArray(String[] stringArray) {
        this.stringArray = stringArray;
    }

    public String getStringIndexed(int index) {
        return this.stringIndexed[index];
    }

    public void setStringIndexed(int index, String value) {
        this.stringIndexed[index] = value;
    }

    public String[] getString2dArray(int index) {
        return this.string2dArray[index];
    }

    public String getStringProperty() {
        return this.stringProperty;
    }

    public void setStringProperty(String stringProperty) {
        this.stringProperty = stringProperty;
    }

    public String getWriteOnlyPropertyValue() {
        return this.writeOnlyProperty;
    }

    public void setWriteOnlyProperty(String writeOnlyProperty) {
        this.writeOnlyProperty = writeOnlyProperty;
    }

    public boolean getInvalidBoolean() {
        return this.invalidBoolean;
    }

    public boolean isInvalidBoolean() {
        return this.invalidBoolean;
    }

    public void setInvalidBoolean(String invalidBoolean) {
        this.invalidBoolean = "true".equalsIgnoreCase(invalidBoolean) || "yes".equalsIgnoreCase(invalidBoolean) || "1".equalsIgnoreCase(invalidBoolean);
    }

    public static int currentCounter() {
        return counter;
    }

    public static void incrementCounter() {
        TestBean.incrementCounter(1);
    }

    public static void incrementCounter(int amount) {
        counter += amount;
    }

    public static void incrementCounter(Number amount) {
        counter += 2 * amount.intValue();
    }

    public class MappedTestBean {
        public void setValue(String key, String val) {
        }

        public String getValue(String key) {
            return "Mapped Value";
        }
    }
}

