/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class FloatConverterTestCase
extends NumberConverterTestBase {
    private Converter converter = null;

    public FloatConverterTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new Float("-12");
        this.numbers[1] = new Float("13");
        this.numbers[2] = new Float("-22");
        this.numbers[3] = new Float("23");
    }

    public static TestSuite suite() {
        return new TestSuite(FloatConverterTestCase.class);
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new FloatConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new FloatConverter(defaultValue);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Float.class;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Float.MIN_VALUE), "-17.2", "-1.1", "0.0", "1.1", "17.2", String.valueOf(Float.MAX_VALUE), new Byte(7), new Short(8), new Integer(9), new Long(10L), new Float(11.1), new Double(12.2)};
        Float[] expected = new Float[]{new Float(Float.MIN_VALUE), new Float(-17.2), new Float(-1.1), new Float(0.0), new Float(1.1), new Float(17.2), new Float(Float.MAX_VALUE), new Float(7.0f), new Float(8.0f), new Float(9.0f), new Float(10.0f), new Float(11.1), new Float(12.2)};
        for (int i = 0; i < expected.length; ++i) {
            FloatConverterTestCase.assertEquals((String)(message[i] + " to Float"), (double)expected[i].floatValue(), (double)((Float)this.converter.convert(Float.class, input[i])).floatValue(), (double)1.0E-5);
            FloatConverterTestCase.assertEquals((String)(message[i] + " to float"), (double)expected[i].floatValue(), (double)((Float)this.converter.convert(Float.TYPE, input[i])).floatValue(), (double)1.0E-5);
            FloatConverterTestCase.assertEquals((String)(message[i] + " to null type"), (double)expected[i].floatValue(), (double)((Float)this.converter.convert(null, input[i])).floatValue(), (double)1.0E-5);
        }
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Float> clazz = Float.class;
        Double max = new Double(3.4028234663852886E38);
        Double tooBig = new Double(Double.MAX_VALUE);
        FloatConverterTestCase.assertEquals((String)"Maximum", (Object)new Float(Float.MAX_VALUE), (Object)converter.convert(clazz, (Object)max));
        try {
            FloatConverterTestCase.assertEquals((String)"Too Big", null, (Object)converter.convert(clazz, (Object)tooBig));
            FloatConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

