/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanUtils;

public class Jira465TestCase
extends TestCase {
    private static final String PATH = "foo[0]";
    private static final String NEW_VALUE = "2";
    private static final String OLD_VALUE = "1";

    private static void changeValue(Object bean) {
        try {
            BeanUtils.setProperty((Object)bean, (String)PATH, (Object)NEW_VALUE);
        }
        catch (Exception e) {
            Jira465TestCase.fail((String)("Could not set property: " + e));
        }
    }

    public void testArrayProperty() throws InvocationTargetException, IllegalAccessException {
        ArrayProp bean = new ArrayProp();
        Jira465TestCase.changeValue(bean);
        Jira465TestCase.assertEquals((String)"Wrong value", (Object)NEW_VALUE, (Object)bean.getFoo()[0]);
    }

    public void testArrayIndexedProperty() {
        ArrayIndexedProp bean = new ArrayIndexedProp();
        Jira465TestCase.changeValue(bean);
        Jira465TestCase.assertEquals((String)"Wrong value", (Object)NEW_VALUE, (Object)bean.getFoo(0));
    }

    public void testListProperty() {
        ListProp bean = new ListProp();
        Jira465TestCase.changeValue(bean);
        Jira465TestCase.assertEquals((String)"Wrong value", (String)NEW_VALUE, (String)bean.getFoo().get(0));
    }

    public void testListIndexedProperty() {
        ListIndexedProp bean = new ListIndexedProp();
        Jira465TestCase.changeValue(bean);
        Jira465TestCase.assertEquals((String)"Wrong value", (String)NEW_VALUE, (String)bean.getFoo(0));
    }

    public static class ListIndexedProp {
        private final List<String> foo = new ArrayList<String>(Arrays.asList("1"));

        public String getFoo(int i) {
            return this.foo.get(i);
        }

        public void setFoo(int i, String value) {
            this.foo.set(i, value);
        }
    }

    public static class ListProp {
        private List<String> foo = new ArrayList<String>(Arrays.asList("1"));

        public List<String> getFoo() {
            return this.foo;
        }

        public void setFoo(List<String> foo) {
            this.foo = foo;
        }
    }

    public static class ArrayIndexedProp {
        private final Object[] foo = new Object[]{"1"};

        public Object getFoo(int i) {
            return this.foo[i];
        }

        public void setFoo(int i, Object value) {
            this.foo[i] = value;
        }
    }

    public static class ArrayProp {
        private Object[] foo = new Object[]{"1"};

        public Object[] getFoo() {
            return this.foo;
        }

        public void setFoo(Object[] foo) {
            this.foo = foo;
        }
    }
}

