/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.exc.LoadingException;

public final class Pass1Verifier
extends PassVerifier {
    private JavaClass jc;
    private final Verifier myOwner;

    public Pass1Verifier(Verifier owner) {
        this.myOwner = owner;
    }

    @Override
    public VerificationResult do_verify() {
        JavaClass jc;
        try {
            jc = this.getJavaClass();
            if (jc != null && !this.myOwner.getClassName().equals(jc.getClassName()) && !jc.getClassName().endsWith(this.myOwner.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + jc.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (ClassFormatException | LoadingException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (RuntimeException e) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed.  exception occurred:\n" + e.toString());
        }
        if (jc != null) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Repository.lookup() failed. FILE NOT FOUND?");
    }

    private JavaClass getJavaClass() {
        if (this.jc == null) {
            try {
                this.jc = Repository.lookupClass(this.myOwner.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.jc;
    }

    @Override
    public String[] getMessages() {
        return super.getMessages();
    }
}

