/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.ObjectType;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    static final CodeExceptionGen[] EMPTY_ARRAY = new CodeExceptionGen[0];
    private InstructionHandle startPc;
    private InstructionHandle endPc;
    private InstructionHandle handlerPc;
    private ObjectType catchType;

    public CodeExceptionGen(InstructionHandle startPc, InstructionHandle endPc, InstructionHandle handlerPc, ObjectType catchType) {
        this.setStartPC(startPc);
        this.setEndPC(endPc);
        this.setHandlerPC(handlerPc);
        this.catchType = catchType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.startPc == ih || this.endPc == ih || this.handlerPc == ih;
    }

    public ObjectType getCatchType() {
        return this.catchType;
    }

    public CodeException getCodeException(ConstantPoolGen cp) {
        return new CodeException(this.startPc.getPosition(), this.endPc.getPosition() + this.endPc.getInstruction().getLength(), this.handlerPc.getPosition(), this.catchType == null ? 0 : cp.addClass(this.catchType));
    }

    public InstructionHandle getEndPC() {
        return this.endPc;
    }

    public InstructionHandle getHandlerPC() {
        return this.handlerPc;
    }

    public InstructionHandle getStartPC() {
        return this.startPc;
    }

    public void setCatchType(ObjectType catchType) {
        this.catchType = catchType;
    }

    public void setEndPC(InstructionHandle end_pc) {
        BranchInstruction.notifyTarget(this.endPc, end_pc, this);
        this.endPc = end_pc;
    }

    public void setHandlerPC(InstructionHandle handler_pc) {
        BranchInstruction.notifyTarget(this.handlerPc, handler_pc, this);
        this.handlerPc = handler_pc;
    }

    public void setStartPC(InstructionHandle start_pc) {
        BranchInstruction.notifyTarget(this.startPc, start_pc, this);
        this.startPc = start_pc;
    }

    public String toString() {
        return "CodeExceptionGen(" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + ")";
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.startPc == old_ih) {
            targeted = true;
            this.setStartPC(new_ih);
        }
        if (this.endPc == old_ih) {
            targeted = true;
            this.setEndPC(new_ih);
        }
        if (this.handlerPc == old_ih) {
            targeted = true;
            this.setHandlerPC(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + "}");
        }
    }
}

