/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.sample.controller;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class DemoRESTControllerAspect1 {

    /**
     * Logger.
     */
    private static final Logger LOG =
            LoggerFactory.getLogger(DemoRESTControllerAspect1.class);

    @Around("bean(org.apache.cocoon.sample.controller.DemoRESTController)")
    public Object someTestAdvice(final ProceedingJoinPoint pjp)
            throws Throwable {

        LOG.info("Going through around advice 1 - start");
        try {
            return pjp.proceed();
        } finally {
            LOG.info("Going through around advice 1 - end");
        }
    }
}
