/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.acting;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.util.HashMap;

/**
 * AbstractConfigurableAction gives you the infrastructure for easily
 * deploying more Actions that take default parameters.
 *
 * @version $Id: AbstractConfigurableAction.java 587751 2007-10-24 02:41:36Z vgritsenko $
 */
public abstract class AbstractConfigurableAction extends AbstractAction implements Configurable {

    /**
     * Stores (global) configuration parameters as <code>key</code> /
     * <code>value</code> pairs.
     */
    protected HashMap settings = null;

    /**
     * Configures the Action.
     *
     * Takes the children from the <code>Configuration</code> and stores them
     * them as key (configuration name) and value (configuration value)
     * in <code>settings</code>.
     * <br/>
     * This automates parsing of flat string-only configurations.
     * For nested configurations, override this function in your action.
     */
    public void configure(Configuration conf) throws ConfigurationException {
        Configuration[] parameters = conf.getChildren();
        this.settings = new HashMap(parameters.length);
        for (int i = 0; i < parameters.length; i++) {
            String key = parameters[i].getName();
            String val = parameters[i].getValue(null);
            this.settings.put(key, val);
        }
    }
}
