/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.components.serializers.encoding;

/**
 * 
 * 
 * @version $Id: HTMLEncoder.java 587752 2007-10-24 02:47:02Z vgritsenko $
 */
public class HTMLEncoder extends XHTMLEncoder {

    private char APOSTROPHE[] = { '\'' };

    /**
     * Create a new instance of this <code>HTMLEncoder</code>.
     */
    public HTMLEncoder() {
        super("X-W3C-HTML");
    }
    
    /**
     * Create a new instance of this <code>HTMLEncoder</code>.
     *
     * @param name A name for this <code>Encoding</code>.
     * @throws NullPointerException If one of the arguments is <b>null</b>.
     */
    protected HTMLEncoder(String name) {
        super(name);
    }
    
    /**
     * Return true or false wether this encoding can encode the specified
     * character or not.
     */
    protected boolean compile(char c) {
        if (c == '\'') return(true);
        return(super.compile(c));
    }

    /**
     * Return an array of characters representing the encoding for the
     * specified character.
     */
    public char[] encode(char c) {
        if (c == '\'') return(APOSTROPHE);
        return (super.encode(c));
    }
}