/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.components.serializers.encoding;

/**
 * 
 * 
 * @version $Id: Charset.java 587752 2007-10-24 02:47:02Z vgritsenko $
 */
public interface Charset extends Verifier {

    /**
     * Return the primary name of this <code>Charset</code>
     */
    String getName();

    /**
     * Return all alias names for this <code>Charset</code>
     */
    String[] getAliases();

    /**
     * Compare two <code>Charset</code> instances for equality.
     */
    boolean equals(Charset charset);
}
