/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.components.source;

import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

import org.apache.cocoon.components.source.helpers.SourceLock;

/**
 * A source, which could be locked
 *
 * @version $Id: LockableSource.java 587761 2007-10-24 03:08:05Z vgritsenko $
 */
public interface LockableSource extends Source {

    /**
     * Add a lock to this source
     *
     * @param sourcelock Lock, which should be added
     *
     * @throws SourceException If an exception occurs during this operation
     */
    void addSourceLocks(SourceLock sourcelock) throws SourceException;

    /**
     * Returns a list of locks on the source.
     *
     * @return Enumeration of SourceLock
     */
    SourceLock[] getSourceLocks() throws SourceException;
}

