/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.profiling.statistics;

import java.util.Collection;

/**
 * The collector is the central component collecting various statistics about
 * the current request.
 *
 * @version $Id: Collector.java 587761 2007-10-24 03:08:05Z vgritsenko $
 * @since 2.1.10
 */
public interface Collector {

    /**
     * Add a new statistics object.
     */
    void addStatistics(Statistics stats);

    /** 
     * Collection of {@link Report}s.
     */
    Collection getStatistics();

    /**
     * Collection of {@link PageReport}s.
     */
    Collection getPageReports();

    void setCollectingStatistics(boolean value);

    boolean isCollectingStatistics();

    void clear();
}
