/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.portal;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Information and object dealing with the current request response cycle.
 *
 * @version $Id: RequestContext.java 609768 2008-01-07 20:13:49Z cziegeler $
 * @since 2.2
 */
public interface RequestContext {

    String getBasePath();

    HttpServletRequest getRequest();

    HttpServletResponse getResponse();

    /**
     * Is the request an Ajax request?
     *
     * @return true if this is an Ajax request
     */
    boolean isAjaxRequest();

    ServletContext getServletContext();
}
