/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.components.cron;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.apache.cocoon.util.AbstractLogEnabled;


/**
 * Serviceable CronJob
 *
 * @since 2.1.4
 * @version $Id: ServiceableCronJob.java 587758 2007-10-24 02:55:27Z vgritsenko $
 */
public abstract class ServiceableCronJob extends AbstractLogEnabled
                                         implements CronJob, Serviceable {

    /** The service manager */
    protected ServiceManager manager;


	public void service(ServiceManager manager) throws ServiceException {
		this.manager = manager;
	}
}
