/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.MoveableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.FileTimeStampValidity;

public class FileSource
implements ModifiableTraversableSource,
MoveableSource {
    private File m_file;
    private String m_scheme;
    private String m_uri;

    public FileSource(String uri) throws SourceException, MalformedURLException {
        int pos = SourceUtil.indexOfSchemeColon(uri);
        if (pos == -1) {
            throw new MalformedURLException("Invalid URI : " + uri);
        }
        String scheme = uri.substring(0, pos);
        String fileName = uri.substring(pos + 1);
        fileName = SourceUtil.decodePath(fileName);
        this.init(scheme, new File(fileName));
    }

    public FileSource(String scheme, File file) throws SourceException {
        this.init(scheme, file);
    }

    private void init(String scheme, File file) throws SourceException {
        String uri;
        this.m_scheme = scheme;
        try {
            uri = file.toURL().toExternalForm();
            if (uri.length() > 6 && uri.startsWith("file:/") && uri.charAt(6) != '/') {
                uri = "file:///" + uri.substring(6);
            }
        }
        catch (MalformedURLException mue) {
            throw new SourceException("Failed to get URL for file " + file, mue);
        }
        if (!uri.startsWith(scheme)) {
            uri = scheme + ':' + uri.substring(uri.indexOf(58) + 1);
        }
        this.m_uri = uri;
        this.m_file = file;
    }

    public File getFile() {
        return this.m_file;
    }

    public long getContentLength() {
        return this.m_file.length();
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        try {
            return new FileInputStream(this.m_file);
        }
        catch (FileNotFoundException fnfe) {
            throw new SourceNotFoundException(this.m_uri + " doesn't exist.", fnfe);
        }
    }

    public long getLastModified() {
        return this.m_file.lastModified();
    }

    public String getMimeType() {
        return URLConnection.getFileNameMap().getContentTypeFor(this.m_file.getName());
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getURI() {
        return this.m_uri;
    }

    public SourceValidity getValidity() {
        if (this.m_file.exists()) {
            return new FileTimeStampValidity(this.m_file);
        }
        return null;
    }

    public void refresh() {
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public Source getChild(String name) throws SourceException {
        if (!this.m_file.isDirectory()) {
            throw new SourceException(this.getURI() + " is not a directory");
        }
        return new FileSource(this.getScheme(), new File(this.m_file, name));
    }

    public Collection getChildren() throws SourceException {
        if (!this.m_file.isDirectory()) {
            throw new SourceException(this.getURI() + " is not a directory");
        }
        File[] files = this.m_file.listFiles();
        FileSource[] children = new FileSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            children[i] = new FileSource(this.getScheme(), files[i]);
        }
        return Arrays.asList(children);
    }

    public String getName() {
        return this.m_file.getName();
    }

    public Source getParent() throws SourceException {
        return new FileSource(this.getScheme(), this.m_file.getParentFile());
    }

    public boolean isCollection() {
        return this.m_file.isDirectory();
    }

    public OutputStream getOutputStream() throws IOException {
        File tmpFile = new File(this.getFile().getPath() + ".tmp");
        tmpFile.getParentFile().mkdirs();
        if (this.getFile().exists() && !this.getFile().canWrite()) {
            throw new IOException("Cannot write to file " + this.getFile().getPath());
        }
        if (!tmpFile.createNewFile()) {
            throw new ConcurrentModificationException("File " + this.getFile().getPath() + " is already being written by another thread");
        }
        return new FileSourceOutputStream(tmpFile, this);
    }

    public boolean canCancel(OutputStream stream) {
        FileSourceOutputStream fsos;
        if (stream instanceof FileSourceOutputStream && (fsos = (FileSourceOutputStream)stream).getSource() == this) {
            return fsos.canCancel();
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void cancel(OutputStream stream) throws SourceException {
        FileSourceOutputStream fsos;
        if (stream instanceof FileSourceOutputStream && (fsos = (FileSourceOutputStream)stream).getSource() == this) {
            try {
                fsos.cancel();
            }
            catch (Exception e) {
                throw new SourceException("Exception during cancel.", e);
            }
            return;
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void delete() throws SourceException {
        if (!this.m_file.exists()) {
            throw new SourceNotFoundException("Cannot delete non-existing file " + this.m_file.toString());
        }
        if (!this.m_file.delete()) {
            throw new SourceException("Could not delete " + this.m_file.toString() + " (unknown reason)");
        }
    }

    public void makeCollection() throws SourceException {
        this.m_file.mkdirs();
    }

    public void copyTo(Source destination) throws SourceException {
        try {
            SourceUtil.copy(this.getInputStream(), ((ModifiableSource)destination).getOutputStream());
        }
        catch (IOException ioe) {
            throw new SourceException("Couldn't copy " + this.getURI() + " to " + destination.getURI(), ioe);
        }
    }

    public void moveTo(Source destination) throws SourceException {
        if (destination instanceof FileSource) {
            File dest = ((FileSource)destination).getFile();
            File parent = dest.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            if (!this.m_file.renameTo(dest)) {
                throw new SourceException("Couldn't move " + this.getURI() + " to " + destination.getURI());
            }
        } else {
            SourceUtil.move(this, destination);
        }
    }

    private static class FileSourceOutputStream
    extends FileOutputStream {
        private File m_tmpFile;
        private boolean m_isClosed = false;
        private FileSource m_source;

        public FileSourceOutputStream(File tmpFile, FileSource source) throws IOException {
            super(tmpFile);
            this.m_tmpFile = tmpFile;
            this.m_source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.m_isClosed) {
                super.close();
                try {
                    if (this.m_source.getFile().exists()) {
                        this.m_source.getFile().delete();
                    }
                    if (!this.m_tmpFile.renameTo(this.m_source.getFile())) {
                        throw new IOException("Could not rename " + this.m_tmpFile.getAbsolutePath() + " to " + this.m_source.getFile().getAbsolutePath());
                    }
                }
                finally {
                    if (this.m_tmpFile.exists()) {
                        this.m_tmpFile.delete();
                    }
                    this.m_isClosed = true;
                }
            }
        }

        public boolean canCancel() {
            return !this.m_isClosed;
        }

        public void cancel() throws Exception {
            if (this.m_isClosed) {
                throw new IllegalStateException("Cannot cancel : outputstrem is already closed");
            }
            this.m_isClosed = true;
            super.close();
            this.m_tmpFile.delete();
        }

        public void finalize() {
            if (!this.m_isClosed && this.m_tmpFile.exists()) {
                this.m_tmpFile.delete();
            }
        }

        public FileSource getSource() {
            return this.m_source;
        }
    }
}

