/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.cocoon.core.container.spring.avalon.PoolableFactoryBean;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class PoolableProxyHandler
implements InvocationHandler,
Runnable {
    private final ThreadLocal componentHolder = new ThreadLocal();
    private final PoolableFactoryBean handler;
    private final String attributeName;

    public PoolableProxyHandler(PoolableFactoryBean handler) {
        this.handler = handler;
        this.attributeName = PoolableProxyHandler.class.getName() + '/' + this.handler.hashCode();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("putBackIntoAvalonPool")) {
            this.run();
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                attributes.removeAttribute(this.attributeName, 0);
            }
            return null;
        }
        if (method.getName().equals("hashCode") && args == null) {
            return new Integer(this.hashCode());
        }
        if (this.componentHolder.get() == null) {
            this.componentHolder.set(this.handler.getFromPool());
            RequestContextHolder.currentRequestAttributes().registerDestructionCallback(this.attributeName, (Runnable)this, 0);
        }
        try {
            return method.invoke(this.componentHolder.get(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public void run() {
        Object o = this.componentHolder.get();
        if (o != null) {
            this.handler.putIntoPool(o);
        }
        this.componentHolder.set(null);
    }
}

